/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.subscriptions;

import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.subscriptions.Subscription;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyChain
extends LinkedList<PropertyShape> {
    private transient SomlSchema soml;

    public PropertyChain() {
    }

    public PropertyChain(Collection<? extends PropertyShape> propChains) {
        super(propChains);
    }

    public static List<PropertyChain> fromSubscription(Subscription subscription) {
        return PropertyChain.getIndexedProperties(subscription);
    }

    public String getName() {
        if (this.size() == 0) {
            return "";
        }
        return this.stream().map(this.toPropName()).collect(Collectors.joining("_"));
    }

    public List<String> asIriChain() {
        if (this.size() == 0) {
            return Collections.emptyList();
        }
        if (this.isIdChain()) {
            return Collections.singletonList("$self");
        }
        return this.stream().filter(prop -> !(prop instanceof ShapeReplacement)).map(this.toPropIri()).map(arg_0 -> ((Prefixes)this.getSoml().getPrefixes()).toIri(arg_0)).collect(Collectors.toList());
    }

    private static List<PropertyChain> getIndexedProperties(Subscription subscription) {
        Shape subscriptionShape = subscription.getSubscriptionType();
        if (subscriptionShape == null) {
            return Collections.emptyList();
        }
        String subscriptionType = subscriptionShape.asGraphQl();
        List rootSelection = Stream.concat(subscription.getSelections().stream().filter(selection -> selection.getType().equals(subscriptionType)).flatMap(selection -> selection.getSelections().stream().filter(Selection::isRequestedByUser)), subscription.getWhereSelections().stream()).distinct().collect(Collectors.toList());
        List<PropertyChain> propChains = rootSelection.stream().flatMap(PropertyChain::toPropertyChains).filter(chain -> !chain.isEmpty()).distinct().collect(Collectors.toList());
        if (subscription.getWhereSelections().stream().map(Selection::getName).anyMatch("id"::equals)) {
            propChains.add(0, new PropertyChain((Collection<? extends PropertyShape>)Collections.singletonList(subscriptionShape.getPropertyOrFail("id"))));
        }
        return propChains;
    }

    private static Stream<PropertyChain> toPropertyChains(Selection selection) {
        List<PropertyShape> ownProps;
        PropertyShape prop = selection.getProperty().orElse(null);
        if (prop == null) {
            return Stream.of(new PropertyChain());
        }
        if (PropertyChain.shouldAddClassPrefix(selection)) {
            ownProps = new LinkedList<PropertyShape>();
            ownProps.add(new ShapeReplacement(prop.getContainedIn().getContainedIn()));
            ownProps.add(prop);
        } else {
            ownProps = Collections.singletonList(prop);
        }
        if (PropertyChain.isSelectionLangValueOrLang(selection)) {
            return Stream.of(new PropertyChain());
        }
        if (selection.getSelections().isEmpty() && selection.getWhereSelections().isEmpty()) {
            PropertyChain chain2 = new PropertyChain();
            if (!selection.getName().equals("id")) {
                chain2.addAll(ownProps);
            }
            return Stream.of(chain2);
        }
        Stream<PropertyChain> childStream = Stream.concat(selection.getSelections().stream(), selection.getWhereSelections().stream()).flatMap(PropertyChain::toPropertyChains).map(chain -> {
            chain.addAll(0, ownProps);
            return chain;
        });
        return Stream.concat(Stream.of(new PropertyChain((Collection<? extends PropertyShape>)ownProps)), childStream);
    }

    private static boolean shouldAddClassPrefix(Selection selection) {
        SomlSchema somlSchema = selection.getDefinedInType().getContainedIn().getContainedIn();
        Shape shape = (Shape)somlSchema.getObjects().get((Object)selection.getParentShapeId());
        return shape != null && !shape.getProperty(((PropertyShape)selection.getProperty().orElseThrow(() -> new IllegalStateException("Invalid selection - missing propertyShape"))).getName()).isPresent();
    }

    private static boolean isSelectionLangValueOrLang(Selection selection) {
        if (!selection.getName().equals("value") && !selection.getName().equals("lang")) {
            return false;
        }
        Optional prop = selection.getProperty();
        if (!prop.isPresent()) {
            return false;
        }
        return ((PropertyShape)prop.get()).getContainedIn().getContainedIn().getId().equals("Literal");
    }

    private SomlSchema getSoml() {
        if (this.soml == null) {
            this.soml = this.stream().filter(prop -> !(prop instanceof ShapeReplacement)).findFirst().orElseThrow(IllegalStateException::new).getContainedIn().getContainedIn().getContainedIn().getContainedIn();
        }
        return this.soml;
    }

    private Function<PropertyShape, String> toPropName() {
        return prop -> prop.getName().equals("id") ? "entityId" : PropertyChain.toName(this.getSoml(), prop.getName());
    }

    private Function<PropertyShape, String> toPropIri() {
        return propShape -> propShape.getName().equals("id") ? "$self" : this.getSoml().getPrefixes().toIri(propShape.getRdfProperty());
    }

    private boolean isIdChain() {
        return this.size() == 1 && ((PropertyShape)this.get(0)).getName().equals("id");
    }

    private static String toName(SomlSchema soml, String value) {
        return soml.getPrefixes().toName(value);
    }

    private static class ShapeReplacement
    extends PropertyShape {
        private final Shape shape;

        public ShapeReplacement(Shape shape) {
            this.shape = shape;
        }

        public String getName() {
            return this.shape.getId();
        }
    }
}

