/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins.entitychange;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.parser.argument.WhereArgumentParser;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionTraverserContext;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Value;
import com.ontotext.platform.plugins.ConnectorFilterBuilder;
import com.ontotext.platform.plugins.PluginGenerationUtil;
import com.ontotext.platform.plugins.PluginManager;
import com.ontotext.platform.plugins.PluginRuntimeException;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import com.ontotext.subscriptions.PropertyChain;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Literal;
import org.json.JSONObject;

public class EntityChangePluginGenerator {
    private static final Map<String, Object> GENERAL_CONFIG_TEMPLATE;
    private static final Map<String, Object> FIELD_TEMPLATE;
    private static final Set<String> FORBIDDEN_PROPERTIES;
    private static final WhereArgumentParser WHERE_ARGUMENT_PARSER;
    private static final ConnectorFilterBuilder FILTER_BUILDER;
    private static final FilterShortPrinter PRINTER;
    private static final HashFunction HASH_FUNCTION;

    private EntityChangePluginGenerator() {
    }

    public static String getPluginName(Shape shape, ExpressionValue<Object> expressionValue) {
        String name = shape.asGraphQl() + EntityChangePluginGenerator.computeHashForFilter(expressionValue);
        return StringManipulation.toGraphQlModelName((String)name);
    }

    public static String getPluginInstanceName(Shape shape, ExpressionValue<Object> expressionValue) {
        String pluginInstanceName = "otp-" + EntityChangePluginGenerator.getPluginName(shape, expressionValue).toLowerCase();
        return "http://www.ontotext.com/connectors/entity-change/instance#" + pluginInstanceName;
    }

    private static String computeHashForFilter(ExpressionValue<Object> expressionValue) {
        return expressionValue == null ? "" : "_" + String.valueOf(HASH_FUNCTION.hashString((CharSequence)expressionValue.accept((ExpressionVisitor)PRINTER, null), StandardCharsets.UTF_8));
    }

    public static List<PluginManager.CreatePluginConfiguration> generatePlugins(SomlSchema soml) {
        return soml.getObjects().values().stream().filter(shape -> !shape.isSystem()).map(shape -> EntityChangePluginGenerator.generateConfiguration(soml, shape, EntityChangePluginGenerator.getExpressionFilter(shape))).collect(Collectors.toList());
    }

    static PluginManager.CreatePluginConfiguration generateConfiguration(SomlSchema soml, Shape shape, ExpressionValue<Object> filterExpression) {
        return EntityChangePluginGenerator.generateConfiguration(soml, shape, shape.getAllProperties().values().stream().filter(propShape -> !propShape.getName().equals("id")).map(Collections::singletonList).map(PropertyChain::new).collect(Collectors.toList()), filterExpression);
    }

    static PluginManager.CreatePluginConfiguration generateConfiguration(SomlSchema soml, Shape shape, List<PropertyChain> propChains, ExpressionValue<Object> filterExpression) {
        if (propChains.isEmpty()) {
            throw new PluginRuntimeException(ErrorMessages.get((String)"subscription.invalidQuery"), ErrorCode.INVALID_SUBSCRIPTION_QUERY);
        }
        String pluginName = shape.asGraphQl().toLowerCase() + EntityChangePluginGenerator.computeHashForFilter(filterExpression);
        JSONObject configuration = EntityChangePluginGenerator.buildConfig(soml, shape, propChains, filterExpression);
        return new PluginManager.CreatePluginConfiguration(pluginName, configuration);
    }

    private static JSONObject buildConfig(SomlSchema soml, Shape shape, List<PropertyChain> propShapes, ExpressionValue<Object> filterExpression) {
        JSONObject obj = new JSONObject(GENERAL_CONFIG_TEMPLATE).put("fields", EntityChangePluginGenerator.buildFields(propShapes)).put("types", PluginGenerationUtil.getTypesAsIri(soml, shape));
        if (filterExpression != null) {
            obj.put("documentFilter", (Object)EntityChangePluginGenerator.getPluginFilter(filterExpression, soml, shape));
        }
        return obj;
    }

    private static List<JSONObject> buildFields(List<PropertyChain> propChains) {
        return propChains.stream().filter(propChain -> !FORBIDDEN_PROPERTIES.contains(((PropertyShape)propChain.get(propChain.size() - 1)).getName())).map(EntityChangePluginGenerator::buildField).collect(Collectors.toList());
    }

    private static JSONObject buildField(PropertyChain propChain) {
        return new JSONObject(FIELD_TEMPLATE).put("fieldName", (Object)propChain.getName()).put("propertyChain", propChain.asIriChain()).put("multivalued", propChain.stream().anyMatch(PropertyShape::isMultivalued));
    }

    private static String getPluginFilter(ExpressionValue<Object> filterExpression, SomlSchema soml, Shape shape) {
        return ((SparqlNode)filterExpression.accept((ExpressionVisitor)FILTER_BUILDER, (ExpressionVisitorContext)new ConnectorFilterBuilder.FilterContext(soml, shape))).toSparql();
    }

    private static ExpressionValue<Object> getExpressionFilter(Shape shape) {
        if (shape.getSearch() == null || shape.getSearch().getFilter() == null) {
            return null;
        }
        return WHERE_ARGUMENT_PARSER.parseFromString(shape.getSearch().getFilter(), shape);
    }

    static {
        FORBIDDEN_PROPERTIES = ImmutableSet.of((Object)"name");
        WHERE_ARGUMENT_PARSER = new WhereArgumentParser((InputValueConverter)new Rdf4jInputValueConverter());
        FILTER_BUILDER = new ConnectorFilterBuilder().replaceId(true);
        PRINTER = new FilterShortPrinter();
        HASH_FUNCTION = Hashing.md5();
        GENERAL_CONFIG_TEMPLATE = new HashMap<String, Object>(5);
        GENERAL_CONFIG_TEMPLATE.put("languages", Collections.emptyList());
        GENERAL_CONFIG_TEMPLATE.put("readonly", false);
        GENERAL_CONFIG_TEMPLATE.put("detectFields", false);
        GENERAL_CONFIG_TEMPLATE.put("importGraph", false);
        GENERAL_CONFIG_TEMPLATE.put("indexPreviousData", true);
        FIELD_TEMPLATE = new HashMap<String, Object>(4);
        FIELD_TEMPLATE.put("indexed", false);
        FIELD_TEMPLATE.put("stored", false);
        FIELD_TEMPLATE.put("analyzed", false);
        FIELD_TEMPLATE.put("objectFields", Collections.emptyList());
    }

    static class FilterShortPrinter
    extends AbstractExpressionVisitor<String, ExpressionTraverserContext> {
        FilterShortPrinter() {
        }

        protected String visitExpression(Expression target, ExpressionTraverserContext context) {
            return "{" + (String)(target.getName().isEmpty() ? "" : target.getName() + ": ") + String.valueOf(target.getTerms().stream().map(term -> term.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context)).collect(Collectors.toList())) + "}";
        }

        protected String visitExpressionTerm(ExpressionTerm target, ExpressionTraverserContext context) {
            Object value = target.getValue();
            if (value instanceof Value) {
                value = ((Value)value).getValue();
            }
            String valueAsString = value instanceof Literal ? ((Literal)value).getLabel() : (value instanceof ExpressionValue ? (String)((ExpressionValue)value).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context) : (value == null ? "" : value.toString()));
            return target.getName() + ":" + valueAsString;
        }
    }
}

