/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.SimpleExecution;
import com.ontotext.graphql.responder.SimpleQuery;
import com.ontotext.graphql.responder.SimpleRequest;
import com.ontotext.graphql.responder.SimpleUpdate;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.sparql.SparqlEndpoint;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.Nullable;

public class DatabaseRequestInvoker {
    private final SparqlEndpoint endpoint;
    private final EndpointInvokerResolver invokerResolver;

    public DatabaseRequestInvoker(EndpointInvokerResolver invokerResolver, SparqlEndpoint endpoint) {
        this.invokerResolver = invokerResolver;
        this.endpoint = endpoint;
    }

    public Optional<String> executeSelect(String query, TupleQueryResultHandler resultHandler) {
        return this.executeSelect(query, resultHandler, null, null);
    }

    public Optional<String> executeSelect(String query, TupleQueryResultHandler resultHandler, @Nullable Boolean includeInferred, @Nullable Boolean owlSameAs) {
        SimpleRequest request = new SimpleRequest();
        request.addExecution((SimpleExecution)new SimpleQuery((Endpoint)this.endpoint, query, resultHandler));
        request.setSilent(true);
        request.setExpandSameAs(owlSameAs);
        request.setIncludeInferred(includeInferred);
        return this.executeRequest(request);
    }

    public Optional<String> executeUpdate(List<String> updates) {
        return this.executeUpdate(updates, null, null);
    }

    public Optional<String> executeUpdate(List<String> updates, @Nullable Boolean includeInferred, @Nullable Boolean owlSameAs) {
        SimpleRequest request = new SimpleRequest();
        request.addExecution((SimpleExecution)new SimpleUpdate((Endpoint)this.endpoint, updates));
        request.setIncludeInferred(includeInferred);
        request.setExpandSameAs(owlSameAs);
        return this.executeRequest(request);
    }

    public Optional<String> executeSequentialUpdate(List<String> updates) {
        return this.executeSequentialUpdate(updates, null, null);
    }

    public Optional<String> executeSequentialUpdate(List<String> updates, @Nullable Boolean includeInferred, @Nullable Boolean owlSameAs) {
        SimpleRequest request = new SimpleRequest();
        updates.forEach(update -> request.addExecution((SimpleExecution)new SimpleUpdate((Endpoint)this.endpoint, Collections.singletonList(update))));
        request.setIncludeInferred(includeInferred);
        request.setExpandSameAs(owlSameAs);
        return this.executeRequest(request);
    }

    private Optional<String> executeRequest(SimpleRequest request) {
        EndpointInvoker invoker = (EndpointInvoker)this.invokerResolver.resolve((Endpoint)this.endpoint, (ExecutionRequest)request).orElseThrow(IllegalStateException::new);
        List responses = invoker.invoke((Endpoint)this.endpoint, (ExecutionRequest)request);
        if (!responses.stream().allMatch(EndpointExecutionResponse::isValid)) {
            String errorMessage = responses.stream().filter(resp -> !resp.isValid()).map(EndpointExecutionResponse::getErrors).flatMap(errors -> errors.stream().map(Objects::toString)).collect(Collectors.joining(", "));
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }
}

