/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.plugins;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.search.Type;
import com.ontotext.platform.plugins.FieldBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ConnectorTypeMapper {
    static final String KEYWORD = "keyword";
    static final String BOOLEAN = "boolean";
    static final String TEXT = "text";
    static final String SCALED_FLOAT = "scaled_float";
    static final String INTEGER = "integer";
    static final String DOUBLE = "double";
    static final String LONG = "long";
    static final String BYTE = "byte";
    static final String SHORT = "short";
    static final String FLOAT = "float";
    private static final String DATE = "date";
    public static final BiConsumer<FieldBuilder, PropertyShape> NATIVE_KEYWORD = ConnectorTypeMapper.setNativeDatatype("keyword");
    private static final BiConsumer<FieldBuilder, PropertyShape> NATIVE_NESTED = ConnectorTypeMapper.setNativeDatatype("nested");
    private static final Double DEFAULT_SCALING_FACTOR = 1.0;
    private static final Map<String, BiConsumer<FieldBuilder, PropertyShape>> SOML_2_ELASTIC_TYPES = new HashMap<String, BiConsumer<FieldBuilder, PropertyShape>>(32);

    private ConnectorTypeMapper() {
    }

    public static void setEsType(PropertyShape propertyShape, FieldBuilder builder) {
        if (propertyShape.isObjectType() || propertyShape.getScalarType().isLangStringSupported()) {
            NATIVE_NESTED.accept(builder, propertyShape);
            return;
        }
        Type type = propertyShape.getSearchSafe().getType();
        if (type != null && KEYWORD.equals(type.getName())) {
            NATIVE_KEYWORD.accept(builder, propertyShape);
            return;
        }
        SOML_2_ELASTIC_TYPES.getOrDefault(propertyShape.getScalarType().getName(), NATIVE_KEYWORD).accept(builder, propertyShape);
    }

    private static final BiConsumer<FieldBuilder, PropertyShape> setDatatype(String type) {
        return (builder, prop) -> builder.datatype(type);
    }

    private static final BiConsumer<FieldBuilder, PropertyShape> setNativeDatatype(String type) {
        return (builder, prop) -> builder.datatype(ConnectorTypeMapper.nativ(type));
    }

    private static String nativ(String type) {
        return "native:" + type;
    }

    private static BiConsumer<FieldBuilder, PropertyShape> setScalingFactor() {
        return (builder, propertyShape) -> builder.nativeSetting("scaling_factor", ConnectorTypeMapper.getScalingFactor(propertyShape));
    }

    private static double getScalingFactor(PropertyShape property) {
        if (property.getScaleFactor() != null) {
            return property.getScaleFactor();
        }
        return DEFAULT_SCALING_FACTOR;
    }

    static {
        SOML_2_ELASTIC_TYPES.put("iri", ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put(BOOLEAN, ConnectorTypeMapper.setNativeDatatype(BOOLEAN));
        SOML_2_ELASTIC_TYPES.put("string", ConnectorTypeMapper.setNativeDatatype(TEXT));
        SOML_2_ELASTIC_TYPES.put("int", ConnectorTypeMapper.setNativeDatatype(INTEGER));
        SOML_2_ELASTIC_TYPES.put(DOUBLE, ConnectorTypeMapper.setNativeDatatype(DOUBLE));
        SOML_2_ELASTIC_TYPES.put("decimal", ConnectorTypeMapper.setNativeDatatype(SCALED_FLOAT).andThen(ConnectorTypeMapper.setScalingFactor()));
        SOML_2_ELASTIC_TYPES.put(LONG, ConnectorTypeMapper.setNativeDatatype(LONG));
        SOML_2_ELASTIC_TYPES.put("unsignedLong", ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put("unsignedInt", ConnectorTypeMapper.setNativeDatatype(LONG));
        SOML_2_ELASTIC_TYPES.put("unsignedShort", ConnectorTypeMapper.setNativeDatatype(INTEGER));
        SOML_2_ELASTIC_TYPES.put("unsignedByte", ConnectorTypeMapper.setNativeDatatype(SHORT));
        SOML_2_ELASTIC_TYPES.put("positiveFloat", ConnectorTypeMapper.setNativeDatatype(FLOAT));
        SOML_2_ELASTIC_TYPES.put("nonPositiveFloat", ConnectorTypeMapper.setNativeDatatype(FLOAT));
        SOML_2_ELASTIC_TYPES.put("negativeFloat", ConnectorTypeMapper.setNativeDatatype(FLOAT));
        SOML_2_ELASTIC_TYPES.put("nonNegativeFloat", ConnectorTypeMapper.setNativeDatatype(FLOAT));
        SOML_2_ELASTIC_TYPES.put(SHORT, ConnectorTypeMapper.setNativeDatatype(SHORT));
        SOML_2_ELASTIC_TYPES.put(BYTE, ConnectorTypeMapper.setNativeDatatype(BYTE));
        SOML_2_ELASTIC_TYPES.put(INTEGER, ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put("positiveInteger", ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put("nonPositiveInteger", ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put("negativeInteger", ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put("nonNegativeInteger", ConnectorTypeMapper.setNativeDatatype(KEYWORD));
        SOML_2_ELASTIC_TYPES.put("dateTime", ConnectorTypeMapper.setDatatype("xsd:dateTime"));
        SOML_2_ELASTIC_TYPES.put(DATE, ConnectorTypeMapper.setDatatype("xsd:date"));
        SOML_2_ELASTIC_TYPES.put("time", ConnectorTypeMapper.setDatatype("xsd:time"));
        SOML_2_ELASTIC_TYPES.put("year", ConnectorTypeMapper.setDatatype("xsd:gYear"));
        SOML_2_ELASTIC_TYPES.put("yearMonth", ConnectorTypeMapper.setDatatype("xsd:gYearMonth"));
    }
}

