/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApproximateSelectQueryAttributeExtractor {
    private final QuotedIDFactory idfac;
    private static final Pattern AS = Pattern.compile("(((\\w+)|(\"[^\"]+\")|(`[^`]+`)|(\\[[^]]+]))\\.)*(?<column>(\\w+)|(\"[^\"]+\")|(`[^`]+`)|(\\[[^]]+]))(\\s+(AS\\s+)?(?<alias>(\\w+)|(\"[^\"]+\")|(`[^`]+`)|(\\[[^]]+])))?", 2);
    private static final Pattern BRACKETS = Pattern.compile("\\([^()]*\\)");
    private static final Pattern COL_SEP = Pattern.compile(",");
    private static final Pattern SELECT = Pattern.compile("\\A\\s*SELECT\\s+(DISTINCT\\s)?", 2);
    private static final Pattern FROM = Pattern.compile("\\sFROM\\s", 2);

    public ApproximateSelectQueryAttributeExtractor(QuotedIDFactory idfac) {
        this.idfac = idfac;
    }

    public ImmutableList<QuotedID> getAttributes(String sql) throws InvalidQueryException {
        Matcher startMatcher = SELECT.matcher(sql);
        if (!startMatcher.find()) {
            throw new InvalidQueryException("Error parsing SQL query: Couldn't find SELECT clause", (Object)sql);
        }
        int start = startMatcher.end();
        Matcher endMatcher = FROM.matcher(sql);
        if (!endMatcher.find()) {
            throw new InvalidQueryException("Error parsing SQL query: Couldn't find FROM clause", (Object)sql);
        }
        int end = endMatcher.start();
        String projection = sql.substring(start, end);
        Matcher matcher = BRACKETS.matcher(projection);
        while (matcher.find()) {
            projection = matcher.replaceAll("");
            matcher = BRACKETS.matcher(projection);
        }
        ImmutableList.Builder attributes = ImmutableList.builder();
        for (String column : COL_SEP.split(projection)) {
            Matcher columnMatcher = AS.matcher(column);
            if (!columnMatcher.find()) continue;
            String columnString = columnMatcher.group("column");
            String aliasString = columnMatcher.group("alias");
            QuotedID attribute = this.idfac.createAttributeID(aliasString == null ? columnString : aliasString);
            attributes.add((Object)attribute);
        }
        return attributes.build();
    }
}

