/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.JsonDBTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.UUIDDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class TrinoDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String INT2_STR = "INT2";
    protected static final String INT4_STR = "INT4";
    protected static final String INT8_STR = "INT8";
    protected static final String FLOAT4_STR = "FLOAT4";
    protected static final String FLOAT8_STR = "FLOAT8";
    public static final String TIMETZ_STR = "TIME WITH TIME ZONE";
    public static final String BOOL_STR = "BOOL";
    public static final String UUID_STR = "UUID";
    public static final String JSON_STR = "JSON";
    protected static final String GEOMETRY_STR = "GEOMETRY";
    public static final String DEFAULT_DECIMAL_STR = "DECIMAL(38, 18)";
    public static final String ARRAY_STR = "ARRAY(T)";

    @AssistedInject
    protected TrinoDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(TrinoDBTypeFactory.createTrinoTypeMap(rootTermType, typeFactory), TrinoDBTypeFactory.createTrinoCodeMap(), TrinoDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory, "()"));
    }

    protected TrinoDBTypeFactory(TermType rootTermType, TypeFactory typeFactory, ImmutableList<GenericDBTermType> genericAbstractTypeMap) {
        super(TrinoDBTypeFactory.createTrinoTypeMap(rootTermType, typeFactory), TrinoDBTypeFactory.createTrinoCodeMap(), genericAbstractTypeMap);
    }

    protected static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory, String brackets) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        char openingBracket = brackets.charAt(0);
        char closingBracket = brackets.charAt(1);
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(ARRAY_STR, rootAncestry, s -> {
            if (s.equals("ARRAY")) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBStringType());
            }
            if (!s.startsWith("ARRAY" + openingBracket) || !s.endsWith("" + closingBracket)) {
                return Optional.empty();
            }
            String contents = s.substring(6, s.length() - 1);
            int depth = 0;
            for (int i = 0; i < contents.length(); ++i) {
                if (contents.charAt(i) == openingBracket) {
                    ++depth;
                    continue;
                }
                if (contents.charAt(i) == closingBracket) {
                    --depth;
                    continue;
                }
                if (contents.charAt(i) != ',' || depth != 0) continue;
                return Optional.empty();
            }
            if (depth != 0) {
                return Optional.empty();
            }
            return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(contents));
        });
        ArrayList<ArrayDBTermType> list = new ArrayList<ArrayDBTermType>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    protected static Map<String, DBTermType> createTrinoTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        NonStringNonNumberNonBooleanNonDatetimeDBTermType timeTzType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIMETZ_STR, rootAncestry, typeFactory.getDatatype(XSD.TIME), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.NOTHING);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        UUIDDBTermType uuidType = new UUIDDBTermType(UUID_STR, rootTermType.getAncestry(), xsdString);
        NumberDBTermType defaultDecimalType = new NumberDBTermType(DEFAULT_DECIMAL_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        Map<String, DBTermType> map = TrinoDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(INT2_STR, map.get("SMALLINT"));
        map.put(INT4_STR, map.get("INTEGER"));
        map.put(INT8_STR, map.get("BIGINT"));
        map.put(FLOAT4_STR, map.get("REAL"));
        map.put(FLOAT8_STR, map.get("DOUBLE PRECISION"));
        map.put(DEFAULT_DECIMAL_STR, (DBTermType)defaultDecimalType);
        map.put(TIMETZ_STR, (DBTermType)timeTzType);
        map.put("DATE", (DBTermType)dateType);
        map.put(BOOL_STR, map.get("BOOLEAN"));
        map.put(UUID_STR, (DBTermType)uuidType);
        map.put(GEOMETRY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOMETRY_STR, rootAncestry, xsdString));
        map.put(JSON_STR, (DBTermType)new JsonDBTermTypeImpl(JSON_STR, rootAncestry));
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createTrinoCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = TrinoDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DOUBLE PRECISION");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, "TIMESTAMP WITH TIME ZONE");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, "VARBINARY");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "VARCHAR");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOMETRY, GEOMETRY_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.JSON, JSON_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, DEFAULT_DECIMAL_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return true;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return false;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return false;
    }

    @Override
    public boolean supportsJson() {
        return true;
    }

    @Override
    public boolean supportsArrayType() {
        return true;
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "true";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "false";
    }
}

