/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class SparkSQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String BYTE_STR = "BYTE";
    protected static final String SHORT_STR = "SHORT";
    protected static final String LONG_STR = "LONG";
    protected static final String STRING_STR = "STRING";
    public static final String DECIMAL_38_10_STR = "DECIMAL(38, 10)";
    private static final String ARRAY_STR = "ARRAY<T>";

    @AssistedInject
    protected SparkSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(SparkSQLDBTypeFactory.createSparkSQLTypeMap(rootTermType, typeFactory), SparkSQLDBTypeFactory.createSparkSQLCodeMap(), SparkSQLDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory));
    }

    private static Map<String, DBTermType> createSparkSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdByte = typeFactory.getDatatype(XSD.BYTE);
        RDFDatatype xsdShort = typeFactory.getDatatype(XSD.SHORT);
        RDFDatatype xsdInt = typeFactory.getDatatype(XSD.INT);
        RDFDatatype xsdLong = typeFactory.getDatatype(XSD.LONG);
        RDFDatatype xsdFloat = typeFactory.getDatatype(XSD.FLOAT);
        RDFDatatype xsdDecimal = typeFactory.getDatatype(XSD.DECIMAL);
        NumberDBTermType byteType = new NumberDBTermType(BYTE_STR, rootAncestry, xsdByte, DBTermType.Category.INTEGER);
        NumberDBTermType shortType = new NumberDBTermType(SHORT_STR, rootAncestry, xsdShort, DBTermType.Category.INTEGER);
        NumberDBTermType intType = new NumberDBTermType("INT", rootAncestry, xsdInt, DBTermType.Category.INTEGER);
        NumberDBTermType longType = new NumberDBTermType(LONG_STR, rootAncestry, xsdLong, DBTermType.Category.INTEGER);
        NumberDBTermType decimal3810Type = new NumberDBTermType(DECIMAL_38_10_STR, rootAncestry, xsdDecimal, DBTermType.Category.DECIMAL);
        NumberDBTermType floatType = new NumberDBTermType("FLOAT", rootAncestry, xsdFloat, DBTermType.Category.FLOAT_DOUBLE);
        StringDBTermType stringType = new StringDBTermType(STRING_STR, rootAncestry, typeFactory.getXsdStringDatatype());
        Map<String, DBTermType> map = SparkSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(STRING_STR, (DBTermType)stringType);
        map.put(BYTE_STR, (DBTermType)byteType);
        map.put("TINYINT", (DBTermType)byteType);
        map.put(SHORT_STR, (DBTermType)shortType);
        map.put("SMALLINT", (DBTermType)shortType);
        map.put("INT", (DBTermType)intType);
        map.put("INTEGER", (DBTermType)intType);
        map.put(LONG_STR, (DBTermType)longType);
        map.put("BIGINT", (DBTermType)longType);
        map.put("FLOAT", (DBTermType)floatType);
        map.put("REAL", (DBTermType)floatType);
        map.put(DECIMAL_38_10_STR, (DBTermType)decimal3810Type);
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createSparkSQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = SparkSQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, STRING_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, "BINARY");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, DECIMAL_38_10_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.ARRAY, ARRAY_STR);
        return ImmutableMap.copyOf(map);
    }

    private static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(ARRAY_STR, rootAncestry, s -> {
            if (s.equals("ARRAY")) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBStringType());
            }
            if (!s.startsWith("ARRAY<") || !s.endsWith(">")) {
                return Optional.empty();
            }
            String contents = s.substring(6, s.length() - 1);
            int depth = 0;
            for (int i = 0; i < contents.length(); ++i) {
                if (contents.charAt(i) == '<') {
                    ++depth;
                    continue;
                }
                if (contents.charAt(i) == '>') {
                    --depth;
                    continue;
                }
                if (contents.charAt(i) != ',' || depth != 0) continue;
                return Optional.empty();
            }
            if (depth != 0) {
                return Optional.empty();
            }
            return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(contents));
        });
        ArrayList<ArrayDBTermType> list = new ArrayList<ArrayDBTermType>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "true";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "false";
    }
}

