/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class SnowflakeDBTypeFactory
extends DefaultSQLDBTypeFactory {
    public static final String NUMBER_STR = "NUMBER";
    public static final String NUMBER_38_10_STR = "NUMBER(38,10)";
    public static final String NUMBER_19_STR = "NUMBER(19)";
    public static final String TIMESTAMP_LOCAL_TZ_STR = "TIMESTAMP_LTZ";
    public static final String TIMESTAMPLTZ_STR = "TIMESTAMPLTZ";
    public static final String TIMESTAMP_TZ_STR = "TIMESTAMP_TZ";
    public static final String TIMESTAMPTZ_STR = "TIMESTAMPTZ";
    public static final String TIMESTAMP_NO_TZ_STR = "TIMESTAMP_NTZ";
    public static final String TIMESTAMPNTZ_STR = "TIMESTAMPNTZ";
    protected static final String ARRAY_STR = "ARRAY";

    @AssistedInject
    private SnowflakeDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(SnowflakeDBTypeFactory.createSnowflakeTypeMap(rootTermType, typeFactory), SnowflakeDBTypeFactory.createSnowflakeCodeMap(), SnowflakeDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory));
    }

    private static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(ARRAY_STR, rootAncestry, s -> {
            if (s.equals(ARRAY_STR)) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBStringType());
            }
            return Optional.empty();
        });
        ArrayList<ArrayDBTermType> list = new ArrayList<ArrayDBTermType>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    private static Map<String, DBTermType> createSnowflakeTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        NumberDBTermType numberType = new NumberDBTermType(NUMBER_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        NumberDBTermType number3810Type = new NumberDBTermType(NUMBER_38_10_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        NumberDBTermType number19Type = new NumberDBTermType(NUMBER_19_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdIntegerDatatype(), DBTermType.Category.INTEGER);
        RDFDatatype xsdDatetime = typeFactory.getXsdDatetimeDatatype();
        DatetimeDBTermType timestampLTZType = new DatetimeDBTermType(TIMESTAMP_LOCAL_TZ_STR, rootAncestry, xsdDatetime);
        DatetimeDBTermType timestampTZType = new DatetimeDBTermType(TIMESTAMP_TZ_STR, rootAncestry, xsdDatetime);
        DatetimeDBTermType timestampNTZType = new DatetimeDBTermType(TIMESTAMP_NO_TZ_STR, rootAncestry, xsdDatetime);
        Map<String, DBTermType> map = SnowflakeDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(NUMBER_STR, (DBTermType)numberType);
        map.put(NUMBER_38_10_STR, (DBTermType)number3810Type);
        map.put(NUMBER_19_STR, (DBTermType)number19Type);
        map.put(TIMESTAMP_LOCAL_TZ_STR, (DBTermType)timestampLTZType);
        map.put(TIMESTAMP_TZ_STR, (DBTermType)timestampTZType);
        map.put(TIMESTAMP_NO_TZ_STR, (DBTermType)timestampNTZType);
        map.put(TIMESTAMPLTZ_STR, (DBTermType)timestampLTZType);
        map.put(TIMESTAMPTZ_STR, (DBTermType)timestampTZType);
        map.put(TIMESTAMPNTZ_STR, (DBTermType)timestampNTZType);
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createSnowflakeCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = SnowflakeDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "VARCHAR");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, "BINARY");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, NUMBER_38_10_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.LARGE_INTEGER, NUMBER_19_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, TIMESTAMP_TZ_STR);
        return ImmutableMap.copyOf(map);
    }
}

