/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.UUIDDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;

public class CDataDynamoDBDBTypeFactory
extends DefaultSQLDBTypeFactory {
    public static final String BYTEA_STR = "BYTEA";
    private static final String DEFAULT_DECIMAL_STR = "DECIMAL(38, 18)";
    public static final String UUID_STR = "UUID";
    public static final String DOUBLE_STR = "DOUBLE";

    protected CDataDynamoDBDBTypeFactory(Map<String, DBTermType> typeMap, ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> defaultTypeCodeMap) {
        super(typeMap, defaultTypeCodeMap);
    }

    @AssistedInject
    protected CDataDynamoDBDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(CDataDynamoDBDBTypeFactory.createCDataDynamoDBTypeMap(rootTermType, typeFactory), CDataDynamoDBDBTypeFactory.createCDataDynamoDBCodeMap());
    }

    protected static Map<String, DBTermType> createCDataDynamoDBTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        Map<String, DBTermType> map = CDataDynamoDBDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        NonStringNonNumberNonBooleanNonDatetimeDBTermType byteAType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BYTEA_STR, rootAncestry, typeFactory.getDatatype(XSD.HEXBINARY), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.SAME_TYPE_NO_CONSTANT);
        UUIDDBTermType uuidType = new UUIDDBTermType(UUID_STR, rootTermType.getAncestry(), xsdString);
        NumberDBTermType defaultDecimalType = new NumberDBTermType(DEFAULT_DECIMAL_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        NumberDBTermType doubleType = new NumberDBTermType(DOUBLE_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDoubleDatatype(), DBTermType.Category.FLOAT_DOUBLE);
        map.put("DATE", (DBTermType)dateType);
        map.put(UUID_STR, (DBTermType)uuidType);
        map.put(BYTEA_STR, (DBTermType)byteAType);
        map.put(DEFAULT_DECIMAL_STR, (DBTermType)defaultDecimalType);
        map.put(DOUBLE_STR, (DBTermType)doubleType);
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createCDataDynamoDBCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = CDataDynamoDBDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, DOUBLE_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, "TIMESTAMP");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, BYTEA_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "VARCHAR");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, DEFAULT_DECIMAL_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return false;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return false;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return false;
    }

    @Override
    public boolean supportsJson() {
        return false;
    }

    @Override
    public boolean supportsArrayType() {
        return false;
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "1";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "0";
    }
}

