/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.BigQuerySQLEncodeURLorIRIFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBSampleFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleDBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullToleratingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneDigitBooleanNormFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneDigitDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.UnaryDBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Optional;
import java.util.function.Function;

public class BigQueryDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String NOT_YET_SUPPORTED_MSG = "Not yet supported for BigQuery";
    private static final String REGEXP_CONTAINS_STR = "REGEXP_CONTAINS";
    private static final String TO_JSON = "TO_JSON";
    private static final String JSON_VALUE = "JSON_VALUE";
    private static final String JSON_VALUE_ARRAY = "JSON_VALUE_ARRAY";
    private DBBooleanFunctionSymbol regexpContains;

    @Inject
    protected BigQueryDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(BigQueryDBFunctionSymbolFactory.createBigQueryRegularFunctionTable(typeFactory), typeFactory);
        this.regexpContains = new DefaultSQLSimpleDBBooleanFunctionSymbol(REGEXP_CONTAINS_STR, 2, this.dbBooleanType, this.abstractRootDBType);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createBigQueryRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        HashBasedTable table = HashBasedTable.create(BigQueryDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        table.remove((Object)"REGEXP_LIKE", (Object)2);
        table.remove((Object)"REGEXP_LIKE", (Object)3);
        DefaultSQLSimpleDBBooleanFunctionSymbol regexpContains = new DefaultSQLSimpleDBBooleanFunctionSymbol(REGEXP_CONTAINS_STR, 2, dbBooleanType, abstractRootDBType);
        DefaultSQLSimpleTypedDBFunctionSymbol toJson = new DefaultSQLSimpleTypedDBFunctionSymbol(TO_JSON, 1, typeFactory.getDBTypeFactory().getDBJsonType(), true, abstractRootDBType);
        DefaultSQLSimpleTypedDBFunctionSymbol jsonValue = new DefaultSQLSimpleTypedDBFunctionSymbol(JSON_VALUE, 2, typeFactory.getDBTypeFactory().getDBStringType(), false, abstractRootDBType){

            protected boolean mayReturnNullWithoutNullArguments() {
                return true;
            }
        };
        DefaultSQLSimpleTypedDBFunctionSymbol jsonValueArray = new DefaultSQLSimpleTypedDBFunctionSymbol(JSON_VALUE_ARRAY, 2, typeFactory.getDBTypeFactory().getDBArrayType(typeFactory.getDBTypeFactory().getDBStringType()), false, abstractRootDBType){

            protected boolean mayReturnNullWithoutNullArguments() {
                return true;
            }
        };
        table.put((Object)REGEXP_CONTAINS_STR, (Object)2, (Object)regexpContains);
        table.put((Object)TO_JSON, (Object)1, (Object)toJson);
        table.put((Object)JSON_VALUE, (Object)2, (Object)jsonValue);
        table.put((Object)JSON_VALUE_ARRAY, (Object)2, (Object)jsonValueArray);
        return ImmutableTable.copyOf((Table)table);
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(STRPOS(%s, %s) > 0)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("CASE STRPOS(%s, %s) WHEN 0 THEN '' ELSE SUBSTRING(%s,1,STRPOS(%s, %s)-1) END", str, before, str, str, before);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("CASE STRPOS(%s, %s) WHEN 0 THEN '' ELSE SUBSTRING(%s, STRPOS(%s, %s) + LENGTH(%s)) END", str, after, str, str, after, after);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeHashingFunction("MD5", terms, termConverter, termFactory);
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeHashingFunction("SHA1", terms, termConverter, termFactory);
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeHashingFunction("SHA256", terms, termConverter, termFactory);
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("SHA384: Not yet supported for BigQuery");
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeHashingFunction("SHA512", terms, termConverter, termFactory);
    }

    private String serializeHashingFunction(String functionName, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_HEX(%s(%s))", functionName, termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(LPAD(EXTRACT(TIMEZONE_HOUR FROM %s)::text,2,'0') || ':' || LPAD(EXTRACT(TIMEZONE_MINUTE FROM %s)::text,2,'0'))", str, str);
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, Serializers.getOperatorSerializer((String)"||"));
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FORMAT_TIMESTAMP(\"%%Y-%%m-%%dT%%X%%Ez\", %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String getUUIDNameInDialect() {
        return "GENERATE_UUID";
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new OneDigitDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType booleanType) {
        return new OneDigitBooleanNormFunctionSymbolImpl(booleanType, this.dbStringType);
    }

    @Override
    protected String serializeWeeksBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("TIMESTAMP_DIFF(week): Not yet supported for BigQuery");
    }

    @Override
    protected String serializeDaysBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeTimeBetween("day", terms, termConverter, termFactory);
    }

    @Override
    protected String serializeHoursBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeTimeBetween("hour", terms, termConverter, termFactory);
    }

    @Override
    protected String serializeMinutesBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeTimeBetween("minute", terms, termConverter, termFactory);
    }

    @Override
    protected String serializeSecondsBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeTimeBetween("second", terms, termConverter, termFactory);
    }

    @Override
    protected String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeTimeBetween("millisecond", terms, termConverter, termFactory);
    }

    private String serializeTimeBetween(String timeUnit, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TIMESTAMP_DIFF(%s, %s, %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), timeUnit);
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return this.regexpContains;
    }

    @Override
    protected Optional<DBFunctionSymbol> createRoundFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("ROUND", dbTermType, dbTermType, false, (terms, termConverter, termFactory) -> String.format("CAST(ROUND(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    @Override
    protected Optional<DBFunctionSymbol> createFloorFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("FLOOR", dbTermType, dbTermType, false, (terms, termConverter, termFactory) -> String.format("CAST(FLOOR(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    @Override
    protected Optional<DBFunctionSymbol> createCeilFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("CEIL", dbTermType, dbTermType, false, (terms, termConverter, termFactory) -> String.format("CAST(CEIL(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (terms, termConverter, termFactory) -> String.format("STRING_AGG(%s%s,%s ORDER BY %s)", isDistinct ? "DISTINCT " : "", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    @Override
    protected DBFunctionSymbol createEncodeURLorIRI(boolean preserveInternationalChars) {
        return new BigQuerySQLEncodeURLorIRIFunctionSymbolImpl(this.dbStringType, preserveInternationalChars);
    }

    @Override
    protected DBFunctionSymbol createDBSample(DBTermType termType) {
        return new DBSampleFunctionSymbolImpl(termType, "ANY_VALUE");
    }

    protected DBTermType inferOutputTypeMathOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) {
        if (dbMathOperatorName.equals("/")) {
            return this.dbDecimalType;
        }
        return super.inferOutputTypeMathOperator(dbMathOperatorName, arg1Type, arg2Type);
    }
}

