/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreSettingsImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class OntopSQLCredentialSettingsImpl
extends OntopSQLCoreSettingsImpl
implements OntopSQLCredentialSettings {
    private final Optional<String> jdbcUser = this.getProperty("jdbc.user");
    private final Optional<String> jdbcPassword = this.getProperty("jdbc.password");
    private final ImmutableMap<Object, Object> additionalJDBCPropertyMap;

    protected OntopSQLCredentialSettingsImpl(Properties userProperties) {
        super(userProperties);
        this.additionalJDBCPropertyMap = OntopSQLCredentialSettingsImpl.extractAdditionalJDBCPropertyMap(userProperties);
    }

    @Override
    public Optional<String> getJdbcUser() {
        return this.jdbcUser;
    }

    @Override
    public Optional<String> getJdbcPassword() {
        return this.jdbcPassword;
    }

    @Override
    public Properties getAdditionalJDBCProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.additionalJDBCPropertyMap);
        return properties;
    }

    private static ImmutableMap<Object, Object> extractAdditionalJDBCPropertyMap(Properties properties) {
        return (ImmutableMap)properties.keySet().stream().filter(k -> k instanceof String).map(k -> (String)k).filter(k -> k.startsWith("jdbc.property.")).filter(k -> k.length() > "jdbc.property.".length()).collect(ImmutableCollectors.toMap(k -> k.substring("jdbc.property.".length()), properties::get));
    }
}

