/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOneTupleDummyQueryExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.AttributeAliasFactory;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.IgnoreNullFirstSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

@Singleton
public class SQLServerSelectFromWhereSerializer
extends IgnoreNullFirstSelectFromWhereSerializer {
    @Inject
    private SQLServerSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory));
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new IgnoreNullFirstSelectFromWhereSerializer.IgnoreNullFirstRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS\nFETCH NEXT %d ROWS ONLY", offset, limit);
            }

            @Override
            protected String serializeLimit(long limit, boolean noSortCondition) {
                return String.format("OFFSET 0 ROWS\nFETCH NEXT %d ROWS ONLY", limit);
            }

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS", offset);
            }

            @Override
            protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap, boolean hasOffsetOrLimit) {
                return String.format("%s%s", super.serializeOrderBy(sortConditions, fromColumnMap), hasOffsetOrLimit || sortConditions.isEmpty() ? "" : " OFFSET 0 ROWS\n");
            }

            @Override
            public SelectFromWhereSerializer.QuerySerialization visit(SQLOneTupleDummyQueryExpression sqlOneTupleDummyQueryExpression) {
                String fromString = this.serializeDummyTable();
                String sqlSubString = String.format("(SELECT 1 AS dummyVarSQLServer %s) tdummy", fromString);
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sqlSubString, (ImmutableMap<Variable, QualifiedAttributeID>)ImmutableMap.of());
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                if (indexVar.isPresent()) {
                    throw new SQLSerializationException("SQLServer currently does not support FLATTEN with position arguments.");
                }
                StringBuilder builder = new StringBuilder();
                AttributeAliasFactory attributeAliasFactory = this.createAttributeAliasFactory();
                String jsonVariable = attributeAliasFactory.createAttributeAlias(outputVar.getName() + "json").getSQLRendering();
                String scalarVariable = attributeAliasFactory.createAttributeAlias(outputVar.getName() + "scalar").getSQLRendering();
                builder.append(String.format("%s CROSS APPLY (SELECT (CASE WHEN %s IS NOT NULL THEN %S ELSE %S END) as %s FROM OPENJSON(%s) WITH (%s NVARCHAR(MAX) '$', %s NVARCHAR(MAX) '$' AS JSON)) %s", subQuerySerialization.getString(), jsonVariable, jsonVariable, scalarVariable, ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering(), ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering(), scalarVariable, jsonVariable, this.generateFreshViewAlias().getSQLRendering()));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap())));
            }
        });
    }
}

