/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class PostgresSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    protected PostgresSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            protected String castFloatingConstant(String value, DBTermType dbType) {
                return String.format("%s::%s", value, dbType.getCastName());
            }

            @Override
            protected String serializeDatetimeConstant(String datetime, DBTermType dbType) {
                return String.format("CAST(%s AS %s)", this.serializeStringConstant(datetime), dbType.getCastName());
            }

            @Override
            protected String serializeBooleanConstant(DBConstant booleanConstant) {
                String value = booleanConstant.getValue();
                switch (value.toLowerCase()) {
                    case "false": 
                    case "true": {
                        return value;
                    }
                }
                return "'" + value + "'";
            }
        });
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, final DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("LIMIT %d\nOFFSET %d", limit, offset);
            }

            private QuotedID generateIntermediateVariable(String outputVarName, ImmutableSet<Variable> existingVariables) {
                int index = 1;
                while (true) {
                    String newVarName = outputVarName + "_intermediate" + index;
                    if (existingVariables.stream().noneMatch(v -> v.getName().equals(newVarName))) {
                        return this.createAttributeAliasFactory().createAttributeAlias(newVarName);
                    }
                    ++index;
                }
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                boolean flatteningNDArray = sqlFlattenExpression.getFlattenedType() instanceof ArrayDBTermType && ((DBTermType)((GenericDBTermType)sqlFlattenExpression.getFlattenedType()).getGenericArguments().get(0)).getCategory() == DBTermType.Category.ARRAY;
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(String.format("%%s JOIN LATERAL %s ", this.getFlattenFunctionSymbolString(sqlFlattenExpression.getFlattenedType())), subQuerySerialization.getString(), ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering()));
                indexVar.ifPresent(v -> builder.append(" WITH ORDINALITY "));
                if (flatteningNDArray) {
                    RelationID castAlias = this.generateFreshViewAlias();
                    RelationID outerViewAlias = this.generateFreshViewAlias();
                    QuotedID intermediateOutputVar = this.generateIntermediateVariable(outputVar.getName(), (ImmutableSet<Variable>)allColumnIDs.keySet());
                    builder.append(String.format("AS %s ON TRUE", this.getOutputVarsRendering(intermediateOutputVar.getSQLRendering(), indexVar, allColumnIDs, castAlias)));
                    ImmutableMap variableAliases = (ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap(v -> (Variable)v.getKey(), v -> new QualifiedAttributeID(this.idFactory.createRelationID(outerViewAlias.getSQLRendering()), ((QualifiedAttributeID)v.getValue()).getAttribute())));
                    Object subProjection = subQuerySerialization.getColumnIDs().keySet().stream().filter(v -> variableAliases.containsKey(v)).map(v -> ((QualifiedAttributeID)subQuerySerialization.getColumnIDs().get(v)).getSQLRendering() + " AS " + this.idFactory.createAttributeID(v.getName()).getSQLRendering()).collect(Collectors.joining(", "));
                    if (((String)subProjection).length() > 0) {
                        subProjection = (String)subProjection + ",";
                    }
                    String indexProjection = indexVar.isPresent() ? String.format("%s AS %s, ", new QualifiedAttributeID(castAlias, ((QualifiedAttributeID)allColumnIDs.get((Object)indexVar.get())).getAttribute()), indexVar.get().getName()) : "";
                    return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(String.format("(SELECT %s %s ARRAY(SELECT jsonb_array_elements_text(%s))::%s AS %s FROM %s) %s", subProjection, indexProjection, intermediateOutputVar.getSQLRendering(), ((DBTermType)((ArrayDBTermType)sqlFlattenExpression.getFlattenedType()).getGenericArguments().get(0)).getCastName(), ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering(), builder, outerViewAlias), (ImmutableMap<Variable, QualifiedAttributeID>)variableAliases);
                }
                builder.append(String.format("AS %s ON TRUE", this.getOutputVarsRendering(outputVar, indexVar, allColumnIDs)));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap())));
            }

            private Object getOutputVarsRendering(Variable outputVar, Optional<Variable> indexVar, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs) {
                String outputVarString = ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering();
                return this.getOutputVarsRendering(outputVarString, indexVar, allColumnIDs, this.generateFreshViewAlias());
            }

            private Object getOutputVarsRendering(String outputVarString, Optional<Variable> indexVar, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, RelationID viewAlias) {
                return indexVar.isPresent() ? String.format("%s(%s, %s)", viewAlias.getSQLRendering(), outputVarString, ((QualifiedAttributeID)allColumnIDs.get((Object)indexVar.get())).getSQLRendering()) : outputVarString;
            }

            private String getFlattenFunctionSymbolString(DBTermType dbType) {
                DBTypeFactory dbTypeFactory = dbParameters.getDBTypeFactory();
                if (dbTypeFactory.getDBTermType("JSON").equals(dbType)) {
                    return "json_array_elements(%s)";
                }
                if (dbTypeFactory.getDBTermType("JSONB").equals(dbType)) {
                    return "jsonb_array_elements(%s)";
                }
                if (dbType.getCategory() == DBTermType.Category.ARRAY) {
                    GenericDBTermType genericDbType = (GenericDBTermType)dbType;
                    if (((DBTermType)genericDbType.getGenericArguments().get(0)).getCategory() == DBTermType.Category.ARRAY) {
                        return "jsonb_array_elements(to_jsonb(%s))";
                    }
                    return "unnest(%s)";
                }
                throw new SQLSerializationException("Unsupported nested type for flattening: " + dbType.getName());
            }
        });
    }
}

