/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.generation.serializer.impl.AttributeAliasFactory;
import java.util.HashSet;
import java.util.Set;

public class LimitLengthAttributeAliasFactory
implements AttributeAliasFactory {
    private final QuotedIDFactory rawIdFactory;
    private final Set<String> used = new HashSet<String>();
    private final int maxLength;
    private final int maxIndexLength;
    private final int maxIndexValue;

    LimitLengthAttributeAliasFactory(QuotedIDFactory idFactory, int maxLength, int maxIndexLength) {
        this.rawIdFactory = new RawQuotedIDFactory(idFactory);
        this.maxLength = maxLength;
        this.maxIndexLength = maxIndexLength;
        this.maxIndexValue = (int)Math.pow(10.0, maxIndexLength);
    }

    @Override
    public QuotedID createAttributeAlias(String variable) {
        int length = variable.length();
        if (length <= this.maxLength) {
            this.used.add(variable);
            return this.rawIdFactory.createAttributeID(variable);
        }
        String shortened = variable.substring(0, this.maxLength - this.maxIndexLength);
        for (int i = 0; i < this.maxIndexValue; ++i) {
            String replacement = shortened + i;
            if (!this.used.contains(replacement)) {
                this.used.add(replacement);
                return this.rawIdFactory.createAttributeID(replacement);
            }
            this.used.add(replacement);
        }
        throw new RuntimeException("Impossible to create a new variable/view " + shortened + "??? : already " + this.maxIndexValue + " of them.");
    }
}

