/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DatabaseInfoSupplier;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.stream.Stream;

public class SQLServerLimitOffsetOldVersionNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final DatabaseInfoSupplier databaseInfoSupplier;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final IQTreeTools iqTreeTools;

    @Inject
    protected SQLServerLimitOffsetOldVersionNormalizer(IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory, DatabaseInfoSupplier databaseInfoSupplier, DBFunctionSymbolFactory dbFunctionSymbolFactory, CoreSingletons coreSingletons, IQTreeTools iqTreeTools) {
        super(coreSingletons);
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.databaseInfoSupplier = databaseInfoSupplier;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return super.transform(tree, (Object)variableGenerator);
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child, VariableGenerator variableGenerator) {
        if (!this.databaseInfoSupplier.getDatabaseVersion().isPresent() || Stream.of("8.", "9.", "10.").noneMatch(s -> ((String)this.databaseInfoSupplier.getDatabaseVersion().get()).startsWith((String)s)) || !this.containsSliceNode(tree)) {
            return super.transformSlice(tree, sliceNode, child, (Object)variableGenerator);
        }
        Variable freshVariable = variableGenerator.generateNewVariable();
        ConstructionNode newConstruction = this.iqFactory.createConstructionNode(this.iqTreeTools.getChildrenVariables(child, freshVariable), this.substitutionFactory.getSubstitution(freshVariable, (ImmutableTerm)this.getOrderBySubTerm(child)));
        ImmutableExpression expression = this.getNewFilterExpression(sliceNode, freshVariable);
        FilterNode newFilter = this.iqFactory.createFilterNode(expression);
        Object newChild = child.getRootNode() instanceof OrderByNode ? (IQTree)child.getChildren().get(0) : (!child.getChildren().isEmpty() && ((IQTree)child.getChildren().get(0)).getRootNode() instanceof OrderByNode ? this.iqFactory.createUnaryIQTree((UnaryOperatorNode)((ConstructionNode)child.getRootNode()), (IQTree)((IQTree)child.getChildren().get(0)).getChildren().get(0)) : child);
        IQTree normalizedChild = this.transform((IQTree)newChild, variableGenerator);
        UnaryIQTree newTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newFilter, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstruction, normalizedChild));
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(newTree.getVariables()), (IQTree)newTree);
    }

    private boolean containsSliceNode(IQTree tree) {
        if (tree.getChildren().isEmpty()) {
            return false;
        }
        return tree.getRootNode() instanceof SliceNode || tree.getChildren().stream().anyMatch(this::containsSliceNode);
    }

    private ImmutableFunctionalTerm getOrderBySubTerm(IQTree childTree) {
        if (childTree.getRootNode() instanceof OrderByNode) {
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRowNumberWithOrderBy(), (ImmutableList)((OrderByNode)childTree.getRootNode()).getComparators().asList().stream().map(c -> c.getTerm()).collect(ImmutableCollectors.toList()));
        }
        if (!childTree.getChildren().isEmpty() && ((IQTree)childTree.getChildren().get(0)).getRootNode() instanceof OrderByNode) {
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRowNumberWithOrderBy(), (ImmutableList)((OrderByNode)((IQTree)childTree.getChildren().get(0)).getRootNode()).getComparators().asList().stream().map(c -> c.getTerm()).collect(ImmutableCollectors.toList()));
        }
        return this.termFactory.getDBRowNumber();
    }

    private ImmutableExpression getNewFilterExpression(SliceNode sliceNode, Variable freshVariable) {
        if (sliceNode.getLimit().isPresent() && sliceNode.getOffset() > 0L) {
            return this.termFactory.getConjunction(this.termFactory.getDBDefaultInequality(InequalityLabel.GT, (ImmutableTerm)freshVariable, (ImmutableTerm)this.termFactory.getDBIntegerConstant((int)sliceNode.getOffset())), new ImmutableExpression[]{this.termFactory.getDBDefaultInequality(InequalityLabel.LTE, (ImmutableTerm)freshVariable, (ImmutableTerm)this.termFactory.getDBIntegerConstant((int)sliceNode.getOffset() + ((Long)sliceNode.getLimit().get()).intValue()))});
        }
        if (!sliceNode.getLimit().isPresent()) {
            return this.termFactory.getDBDefaultInequality(InequalityLabel.GT, (ImmutableTerm)freshVariable, (ImmutableTerm)this.termFactory.getDBIntegerConstant((int)sliceNode.getOffset()));
        }
        return this.termFactory.getDBDefaultInequality(InequalityLabel.LTE, (ImmutableTerm)freshVariable, (ImmutableTerm)this.termFactory.getDBIntegerConstant(((Long)sliceNode.getLimit().get()).intValue()));
    }
}

