/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Set;

public class SQLServerInsertOrderByInSliceNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @Inject
    protected SQLServerInsertOrderByInSliceNormalizer(IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory, CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator context) {
        return super.transform(tree, (Object)context);
    }

    private boolean isOrderByPresent(IQTree child) {
        return (Boolean)child.acceptVisitor((IQVisitor)new OrderBySearcher());
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child, VariableGenerator context) {
        if (this.isOrderByPresent(child)) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)sliceNode, this.transform(child, context));
        }
        ConstructionNode topConstruct = this.iqFactory.createConstructionNode(tree.getVariables(), this.substitutionFactory.getSubstitution());
        Variable sortVariable = context.generateNewVariable("slice_sort_column");
        ConstructionNode bottomConstruct = this.iqFactory.createConstructionNode(Sets.union((Set)tree.getVariables(), (Set)ImmutableSet.of((Object)sortVariable)).immutableCopy(), this.substitutionFactory.getSubstitution(sortVariable, (ImmutableTerm)this.termFactory.getDBConstant("", this.termFactory.getTypeFactory().getDBTypeFactory().getDBStringType())));
        OrderByNode orderByNode = this.iqFactory.createOrderByNode(ImmutableList.of((Object)this.iqFactory.createOrderComparator((NonGroundTerm)sortVariable, true)));
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)sliceNode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)topConstruct, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)orderByNode, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)bottomConstruct, this.transform(child, context)))));
    }

    static class OrderBySearcher
    implements IQVisitor<Boolean> {
        OrderBySearcher() {
        }

        public Boolean visitIntensionalData(IntensionalDataNode dataNode) {
            return false;
        }

        public Boolean visitExtensionalData(ExtensionalDataNode dataNode) {
            return false;
        }

        public Boolean visitEmpty(EmptyNode node) {
            return false;
        }

        public Boolean visitTrue(TrueNode node) {
            return false;
        }

        public Boolean visitNative(NativeNode nativeNode) {
            return false;
        }

        public Boolean visitValues(ValuesNode valuesNode) {
            return false;
        }

        public Boolean visitNonStandardLeafNode(LeafIQTree leafNode) {
            return false;
        }

        public Boolean visitConstruction(ConstructionNode rootNode, IQTree child) {
            return false;
        }

        public Boolean visitAggregation(AggregationNode aggregationNode, IQTree child) {
            return false;
        }

        public Boolean visitFilter(FilterNode rootNode, IQTree child) {
            return (Boolean)child.acceptVisitor((IQVisitor)this);
        }

        public Boolean visitFlatten(FlattenNode rootNode, IQTree child) {
            return false;
        }

        public Boolean visitDistinct(DistinctNode rootNode, IQTree child) {
            return (Boolean)child.acceptVisitor((IQVisitor)this);
        }

        public Boolean visitSlice(SliceNode sliceNode, IQTree child) {
            return false;
        }

        public Boolean visitOrderBy(OrderByNode rootNode, IQTree child) {
            return true;
        }

        public Boolean visitNonStandardUnaryNode(UnaryOperatorNode rootNode, IQTree child) {
            return false;
        }

        public Boolean visitLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            return false;
        }

        public Boolean visitNonStandardBinaryNonCommutativeNode(BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            return false;
        }

        public Boolean visitInnerJoin(InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            return false;
        }

        public Boolean visitUnion(UnionNode rootNode, ImmutableList<IQTree> children) {
            return false;
        }

        public Boolean visitNonStandardNaryNode(NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            return false;
        }
    }
}

