/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBOrFunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public class ReformulateConjunctionDisjunctionNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private final TermFactory termFactory;

    @Inject
    protected ReformulateConjunctionDisjunctionNormalizer(CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.termFactory = coreSingletons.getTermFactory();
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return tree.acceptTransformer((IQTreeExtendedTransformer)this, (Object)variableGenerator);
    }

    public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child, VariableGenerator context) {
        ImmutableExpression expression = rootNode.getFilterCondition();
        ImmutableTerm newExpression = this.transformTerm((ImmutableTerm)expression);
        if (newExpression.equals(expression)) {
            return super.transformFilter(tree, rootNode, child, (Object)context);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode((ImmutableExpression)newExpression), child.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context));
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild, VariableGenerator context) {
        Optional expression = rootNode.getOptionalFilterCondition();
        Optional<ImmutableTerm> newExpression = expression.map(this::transformTerm);
        if (newExpression.isEmpty() || newExpression.equals(expression)) {
            return super.transformLeftJoin(tree, rootNode, leftChild, rightChild, (Object)context);
        }
        return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode((ImmutableExpression)newExpression.get()), leftChild.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context), rightChild.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context));
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children, VariableGenerator context) {
        Optional expression = rootNode.getOptionalFilterCondition();
        Optional<ImmutableTerm> newExpression = expression.map(this::transformTerm);
        if (newExpression.isEmpty() || newExpression.equals(expression)) {
            return super.transformInnerJoin(tree, rootNode, children, (Object)context);
        }
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode((ImmutableExpression)newExpression.get()), (ImmutableList)children.stream().map(child -> child.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context)).collect(ImmutableCollectors.toList()));
    }

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child, VariableGenerator context) {
        Substitution newSubstitution = rootNode.getSubstitution().transform(this::transformTerm);
        ConstructionNode newConstruction = this.iqFactory.createConstructionNode(rootNode.getVariables(), newSubstitution);
        if (newConstruction.equals(rootNode)) {
            return super.transformConstruction(tree, rootNode, child, (Object)context);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstruction, child.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context));
    }

    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child, VariableGenerator context) {
        ImmutableList expressions = (ImmutableList)rootNode.getComparators().stream().map(c -> this.iqFactory.createOrderComparator((NonGroundTerm)this.transformTerm((ImmutableTerm)c.getTerm()), c.isAscending())).collect(ImmutableCollectors.toList());
        OrderByNode newOrderBy = this.iqFactory.createOrderByNode(expressions);
        if (newOrderBy.equals(rootNode)) {
            return super.transformOrderBy(tree, rootNode, child, (Object)context);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newOrderBy, child.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context));
    }

    public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child, VariableGenerator context) {
        Substitution newSubstitution = rootNode.getSubstitution().transform(t -> (ImmutableFunctionalTerm)this.transformTerm((ImmutableTerm)t));
        AggregationNode newAggregation = this.iqFactory.createAggregationNode(rootNode.getGroupingVariables(), newSubstitution);
        if (newAggregation.equals(rootNode)) {
            return super.transformAggregation(tree, rootNode, child, (Object)context);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newAggregation, child.acceptTransformer((IQTreeExtendedTransformer)this, (Object)context));
    }

    private ImmutableTerm transformTerm(ImmutableTerm term) {
        if (!(term instanceof ImmutableFunctionalTerm)) {
            return term;
        }
        ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
        if (f.getFunctionSymbol() instanceof DBOrFunctionSymbol) {
            DBOrFunctionSymbol or = (DBOrFunctionSymbol)f.getFunctionSymbol();
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getDBNot(), new ImmutableTerm[]{this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getDBAnd(or.getArity()), (ImmutableList)f.getTerms().stream().map(this::transformTerm).map(t -> this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getDBNot(), new ImmutableTerm[]{t})).collect(ImmutableCollectors.toList()))});
        }
        if (f.getFunctionSymbol() instanceof DBAndFunctionSymbol) {
            DBAndFunctionSymbol and = (DBAndFunctionSymbol)f.getFunctionSymbol();
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getDBNot(), new ImmutableTerm[]{this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getDBOr(and.getArity()), (ImmutableList)f.getTerms().stream().map(this::transformTerm).map(t -> this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.termFactory.getDBFunctionSymbolFactory().getDBNot(), new ImmutableTerm[]{t})).collect(ImmutableCollectors.toList()))});
        }
        return this.termFactory.getImmutableFunctionalTerm(f.getFunctionSymbol(), (ImmutableList)f.getTerms().stream().map(this::transformTerm).collect(ImmutableCollectors.toList()));
    }
}

