/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;

public class ConvertValuesToUnionNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    private final SubstitutionFactory substitutionFactory;

    @Inject
    protected ConvertValuesToUnionNormalizer(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory) {
        super(iqFactory);
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.transform(tree);
    }

    public IQTree transformValues(ValuesNode node) {
        return this.convertToUnion(node);
    }

    private IQTree convertToUnion(ValuesNode valuesNode) {
        ImmutableList orderedVariables = valuesNode.getOrderedVariables();
        ImmutableList substitutionList = (ImmutableList)valuesNode.getValues().stream().map(tuple -> this.substitutionFactory.getSubstitution(orderedVariables, tuple)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(valuesNode.getVariables()), (ImmutableList)substitutionList.stream().map(s -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(s.getDomain(), s), (IQTree)this.iqFactory.createTrueNode())).collect(ImmutableCollectors.toList()));
    }
}

