/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;

public abstract class AbstractTypingNullsDialectExtraNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    protected final TermFactory termFactory;
    protected final SubstitutionFactory substitutionFactory;

    protected AbstractTypingNullsDialectExtraNormalizer(CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.termFactory = coreSingletons.getTermFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.transform(tree);
    }

    protected ImmutableSet<Variable> extractNullVariables(ConstructionNode constructionNode) {
        return constructionNode.getSubstitution().getPreImage(ImmutableTerm::isNull);
    }

    protected IQTree updateSubQuery(IQTree child, ImmutableMap<Variable, ImmutableFunctionalTerm> typedNullMap) {
        if (child.getRootNode() instanceof ConstructionNode) {
            ConstructionNode constructionNode = (ConstructionNode)child.getRootNode();
            Substitution newSubstitution = constructionNode.getSubstitution().builder().transformOrRetain(arg_0 -> typedNullMap.get(arg_0), (t, n) -> t.isNull() ? n : t).build();
            ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(constructionNode.getVariables(), newSubstitution);
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, ((UnaryIQTree)child).getChild());
        }
        return child;
    }
}

