/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.json.JsonDatabaseTable;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNullByDefault;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"relations"})
@NonNullByDefault
public class JsonMetadata
extends JsonOpenObject {
    public final List<JsonDatabaseTable> relations;
    public final Parameters metadata;

    @JsonCreator
    public JsonMetadata(@JsonProperty(value="relations") @Nullable List<JsonDatabaseTable> relations, @JsonProperty(value="metadata") Parameters metadata) {
        this.relations = relations != null ? ImmutableList.copyOf(relations) : ImmutableList.of();
        this.metadata = Objects.requireNonNull(metadata);
    }

    public JsonMetadata(ImmutableMetadata metadata) {
        this(metadata, NamedRelationDefinition::getID);
    }

    public JsonMetadata(ImmutableMetadata metadata, Function<NamedRelationDefinition, RelationID> fkRelationIDExtractor) {
        this.relations = (List)metadata.getAllRelations().stream().map(relation -> new JsonDatabaseTable((NamedRelationDefinition)relation, fkRelationIDExtractor)).collect(ImmutableList.toImmutableList());
        this.metadata = new Parameters(metadata.getDBParameters());
    }

    public static ImmutableList<String> serializeRelationID(RelationID id) {
        return ((ImmutableList)id.getComponents().stream().map(QuotedID::getSQLRendering).collect(ImmutableList.toImmutableList())).reverse();
    }

    public static RelationID deserializeRelationID(QuotedIDFactory idFactory, List<String> o) {
        return idFactory.createRelationID(o.toArray(new String[0]));
    }

    public static List<String> serializeAttributeList(Stream<Attribute> attributes) {
        return (List)attributes.map(a -> a.getID().getSQLRendering()).collect(ImmutableList.toImmutableList());
    }

    public static void deserializeAttributeList(QuotedIDFactory idFactory, List<String> ids, AttributeConsumer consumer) throws MetadataExtractionException {
        try {
            for (String id : ids) {
                consumer.add(idFactory.createAttributeID(id));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
    }

    public static interface AttributeConsumer {
        public void add(QuotedID var1) throws AttributeNotFoundException;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
    @JsonPropertyOrder(value={"dbmsProductName", "dbmsVersion", "driverName", "driverVersion", "quotationString", "extractionTime"})
    public static class Parameters
    extends JsonOpenObject {
        public final @Nullable String dbmsProductName;
        public final @Nullable String dbmsVersion;
        public final @Nullable String driverName;
        public final @Nullable String driverVersion;
        public final @Nullable String quotationString;
        public final @Nullable String extractionTime;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final @Nullable String idFactoryType;
        private final transient // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable QuotedIDFactory.Supplier idFactorySupplier;
        private transient @Nullable QuotedIDFactory cachedIdFactory;

        @JsonCreator
        public Parameters(@JsonProperty(value="dbmsProductName") @Nullable String dbmsProductName, @JsonProperty(value="dbmsVersion") @Nullable String dbmsVersion, @JsonProperty(value="driverName") @Nullable String driverName, @JsonProperty(value="driverVersion") @Nullable String driverVersion, @JsonProperty(value="quotationString") @Nullable String quotationString, @JsonProperty(value="extractionTime") @Nullable String extractionTime, @JsonProperty(value="idFactoryType") @Nullable String idFactoryType, @JacksonInject @Nullable QuotedIDFactory.Supplier idFactorySupplier) {
            this.dbmsProductName = dbmsProductName;
            this.dbmsVersion = dbmsVersion;
            this.driverName = driverName;
            this.driverVersion = driverVersion;
            this.quotationString = quotationString;
            this.extractionTime = extractionTime;
            this.idFactoryType = idFactoryType;
            this.idFactorySupplier = idFactorySupplier;
        }

        public Parameters(DBParameters parameters) {
            this.dbmsProductName = parameters.getDbmsProductName();
            this.dbmsVersion = parameters.getDbmsVersion();
            this.driverName = parameters.getDriverName();
            this.driverVersion = parameters.getDriverVersion();
            this.cachedIdFactory = parameters.getQuotedIDFactory();
            this.quotationString = this.cachedIdFactory.getIDQuotationString();
            String idFactoryType = this.cachedIdFactory.getIDFactoryType();
            this.idFactoryType = !idFactoryType.equals("STANDARD") ? idFactoryType : null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.extractionTime = dateFormat.format(Calendar.getInstance().getTime());
            this.idFactorySupplier = null;
        }

        public QuotedIDFactory createQuotedIDFactory() throws MetadataExtractionException {
            if (this.cachedIdFactory == null) {
                this.cachedIdFactory = (QuotedIDFactory)Optional.ofNullable(this.idFactorySupplier).flatMap(s -> s.get((String)MoreObjects.firstNonNull((Object)this.idFactoryType, (Object)"STANDARD"))).orElseThrow(() -> new MetadataExtractionException("Could not resolve QuotedIDFactory with type identifier " + this.idFactoryType));
            }
            return this.cachedIdFactory;
        }
    }
}

