/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "from", "to"})
public class JsonForeignKey
extends JsonOpenObject {
    public final String name;
    public final Part from;
    public final Part to;
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonForeignKey.class);

    @JsonCreator
    public JsonForeignKey(@JsonProperty(value="name") String name, @JsonProperty(value="from") Part from, @JsonProperty(value="to") Part to) {
        this.name = name;
        this.from = from;
        this.to = to;
    }

    public JsonForeignKey(ForeignKeyConstraint fk, Function<NamedRelationDefinition, RelationID> fkRelationIDExtractor) {
        this.name = fk.getName();
        this.from = new Part(fk.getRelation(), fk.getComponents().stream().map(ForeignKeyConstraint.Component::getAttribute), fkRelationIDExtractor);
        this.to = new Part(fk.getReferencedRelation(), fk.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute), fkRelationIDExtractor);
    }

    public void insert(NamedRelationDefinition relation, MetadataLookup lookup) throws MetadataExtractionException {
        ForeignKeyConstraint.Builder builder;
        try {
            builder = ForeignKeyConstraint.builder((String)this.name, (NamedRelationDefinition)relation, (NamedRelationDefinition)lookup.getRelation(JsonMetadata.deserializeRelationID(lookup.getQuotedIDFactory(), this.to.relation)));
        }
        catch (MetadataExtractionException e) {
            LOGGER.warn("Cannot find table {} for FK {}", this.to.relation, (Object)this.name);
            return;
        }
        try {
            for (int i = 0; i < this.from.columns.size(); ++i) {
                builder.add(lookup.getQuotedIDFactory().createAttributeID(this.from.columns.get(i)), lookup.getQuotedIDFactory().createAttributeID(this.to.columns.get(i)));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
        builder.build();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"relation", "columns"})
    public static class Part
    extends JsonOpenObject {
        public final List<String> relation;
        public final List<String> columns;

        @JsonCreator
        public Part(@JsonProperty(value="relation") List<String> relation, @JsonProperty(value="columns") List<String> columns) {
            this.relation = relation;
            this.columns = columns;
        }

        public Part(NamedRelationDefinition relation, Stream<Attribute> attributes, Function<NamedRelationDefinition, RelationID> fkRelationIDExtractor) {
            this.relation = JsonMetadata.serializeRelationID(fkRelationIDExtractor.apply(relation));
            this.columns = JsonMetadata.serializeAttributeList(attributes);
        }
    }
}

