/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.TeiidQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class TeiidDBMetadataProvider
extends AbstractDBMetadataProvider {
    @AssistedInject
    TeiidDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new TeiidQuotedIDFactory(), coreSingletons);
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID id) {
        return id;
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        return ImmutableList.of((Object)id);
    }

    @Override
    protected RelationID getRelationID(ResultSet rs, String catalogNameColumn, String schemaNameColumn, String tableNameColumn) throws SQLException {
        String[] schemaComponents = rs.getString(schemaNameColumn).split("\\.");
        String[] components = Arrays.copyOf(schemaComponents, schemaComponents.length + 1);
        components[schemaComponents.length] = rs.getString(tableNameColumn);
        return this.rawIdFactory.createRelationID(components);
    }

    @Override
    protected String getRelationCatalog(RelationID id) {
        return null;
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return id.getComponents().subList(1, id.getComponents().size()).reverse().stream().map(QuotedID::getName).collect(Collectors.joining("."));
    }

    @Override
    protected String getRelationName(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).getName();
    }
}

