/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.PostgreSQLQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLServerQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DefaultDBMetadataProvider
extends AbstractDBMetadataProvider {
    private static final int SCHEMA_INDEX = 1;
    private static final int CATALOG_INDEX = 2;

    @AssistedInject
    DefaultDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, DefaultDBMetadataProvider::getQuotedIDFactory, coreSingletons);
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID id) {
        return id;
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        return ImmutableList.of((Object)id);
    }

    @Override
    protected String getRelationCatalog(RelationID relationID) {
        return relationID.getComponents().size() > 2 ? ((QuotedID)relationID.getComponents().get(2)).getName() : null;
    }

    @Override
    protected String getRelationSchema(RelationID relationID) {
        return relationID.getComponents().size() > 1 ? ((QuotedID)relationID.getComponents().get(1)).getName() : null;
    }

    @Override
    protected String getRelationName(RelationID relationID) {
        return ((QuotedID)relationID.getComponents().get(0)).getName();
    }

    @Override
    protected RelationID getRelationID(ResultSet rs, String catalogNameColumn, String schemaNameColumn, String tableNameColumn) throws SQLException {
        return this.rawIdFactory.createRelationID(new String[]{rs.getString(catalogNameColumn), rs.getString(schemaNameColumn), rs.getString(tableNameColumn)});
    }

    public static QuotedIDFactory getQuotedIDFactory(DatabaseMetaData md) throws SQLException {
        if (md.storesMixedCaseIdentifiers()) {
            return new SQLServerQuotedIDFactory();
        }
        if (md.storesLowerCaseIdentifiers()) {
            return new PostgreSQLQuotedIDFactory();
        }
        if (md.storesUpperCaseIdentifiers()) {
            return new SQLStandardQuotedIDFactory();
        }
        LOGGER.warn("Unknown combination of identifier handling rules: " + md.getDatabaseProductName());
        LOGGER.warn("storesLowerCaseIdentifiers: " + md.storesLowerCaseIdentifiers());
        LOGGER.warn("storesUpperCaseIdentifiers: " + md.storesUpperCaseIdentifiers());
        LOGGER.warn("storesMixedCaseIdentifiers: " + md.storesMixedCaseIdentifiers());
        LOGGER.warn("supportsMixedCaseIdentifiers: " + md.supportsMixedCaseIdentifiers());
        LOGGER.warn("storesLowerCaseQuotedIdentifiers: " + md.storesLowerCaseQuotedIdentifiers());
        LOGGER.warn("storesUpperCaseQuotedIdentifiers: " + md.storesUpperCaseQuotedIdentifiers());
        LOGGER.warn("storesMixedCaseQuotedIdentifiers: " + md.storesMixedCaseQuotedIdentifiers());
        LOGGER.warn("supportsMixedCaseQuotedIdentifiers: " + md.supportsMixedCaseQuotedIdentifiers());
        LOGGER.warn("getIdentifierQuoteString: " + md.getIdentifierQuoteString());
        return new SQLStandardQuotedIDFactory();
    }
}

