/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CachingMetadataLookupWithDependencies
extends CachingMetadataLookup {
    private final Map<RelationID, Set<RelationID>> baseRelationIds = new HashMap<RelationID, Set<RelationID>>();

    public CachingMetadataLookupWithDependencies(MetadataProvider provider) {
        super(provider);
    }

    public ImmutableList<NamedRelationDefinition> getBaseRelations(RelationID id) throws MetadataExtractionException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RelationID baseId : this.baseRelationIds.get(id)) {
            builder.add((Object)this.getRelation(baseId));
        }
        return builder.build();
    }

    public MetadataLookup getCachingMetadataLookupFor(final RelationID id) {
        return new MetadataLookup(){
            private final Set<RelationID> bases;
            private final RelationID childRelationId;
            {
                this.bases = CachingMetadataLookupWithDependencies.this.baseRelationIds.computeIfAbsent(id, i -> new HashSet());
                this.childRelationId = id;
            }

            public NamedRelationDefinition getRelation(RelationID baseId) throws MetadataExtractionException {
                if (baseId.equals(this.childRelationId)) {
                    throw new MetadataExtractionException("Self-dependent (i.e. recursive) relations are not supported. Relation: " + this.childRelationId);
                }
                NamedRelationDefinition base = CachingMetadataLookupWithDependencies.this.getRelation(baseId);
                this.bases.add(base.getID());
                return base;
            }

            public RelationDefinition getBlackBoxView(String query) throws MetadataExtractionException, InvalidQueryException {
                return CachingMetadataLookupWithDependencies.this.getBlackBoxView(query);
            }

            public QuotedIDFactory getQuotedIDFactory() {
                return CachingMetadataLookupWithDependencies.this.getQuotedIDFactory();
            }
        };
    }

    public ImmutableMultimap<RelationID, RelationID> getChildrenMultimap() {
        return (ImmutableMultimap)this.baseRelationIds.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(parent -> Maps.immutableEntry((Object)parent, (Object)((RelationID)e.getKey())))).collect(ImmutableCollectors.toMultimap());
    }
}

