/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.dbschema.impl.DatabaseTableDefinition;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.RelationNotFoundInMetadataException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.spec.sqlparser.ApproximateSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.sqlparser.DefaultSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.sqlparser.ParserViewDefinition;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.TokenMgrException;
import net.sf.jsqlparser.statement.select.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBMetadataProvider
implements DBMetadataProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDBMetadataProvider.class);
    protected final Connection connection;
    protected final DBParameters dbParameters;
    protected final DatabaseMetaData metadata;
    protected final String escape;
    protected final QuotedIDFactory rawIdFactory;
    private final CoreSingletons coreSingletons;
    private final DBTypeFactory dbTypeFactory;
    private final OntopOBDASettings settings;

    AbstractDBMetadataProvider(Connection connection, QuotedIDFactoryFactory idFactoryProvider, CoreSingletons coreSingletons) throws MetadataExtractionException {
        try {
            this.connection = connection;
            this.metadata = connection.getMetaData();
            this.escape = this.metadata.getSearchStringEscape();
            QuotedIDFactory idFactory = idFactoryProvider.create(this.metadata);
            this.rawIdFactory = new RawQuotedIDFactory(idFactory);
            String dbVersion = this.metadata.getDatabaseProductVersion();
            this.dbParameters = new BasicDBParametersImpl(this.metadata.getDriverName(), this.metadata.getDriverVersion(), this.metadata.getDatabaseProductName(), dbVersion, idFactory, coreSingletons);
            coreSingletons.getDatabaseInfoSupplier().setDatabaseVersion(dbVersion);
            this.coreSingletons = coreSingletons;
            this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
            OntopModelSettings modelSettings = coreSingletons.getSettings();
            if (!(modelSettings instanceof OntopOBDASettings)) {
                throw new MinorOntopInternalBugException("Was expecting the settings being an instance of OntopOBDASettings");
            }
            this.settings = (OntopOBDASettings)modelSettings;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.dbParameters.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    public void normalizeAndOptimizeRelations(List<NamedRelationDefinition> relationDefinitions) {
    }

    protected OntopOBDASettings getSettings() {
        return this.settings;
    }

    protected boolean isRelationExcluded(RelationID id) {
        return false;
    }

    protected ResultSet getRelationIDsResultSet() throws SQLException {
        return this.metadata.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
    }

    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        ImmutableList immutableList;
        block9: {
            ResultSet rs = this.getRelationIDsResultSet();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                while (rs.next()) {
                    RelationID id = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                    if (this.isRelationExcluded(id) && !this.settings.exposeSystemTables()) continue;
                    builder.add((Object)id);
                }
                immutableList = builder.build();
                if (rs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new MetadataExtractionException((Exception)e);
                }
            }
            rs.close();
        }
        return immutableList;
    }

    protected abstract RelationID getRelationID(ResultSet var1, String var2, String var3, String var4) throws SQLException;

    protected void checkSameRelationID(RelationID extractedId, RelationID givenId, String method) throws MetadataExtractionException {
        if (!extractedId.equals(givenId)) {
            throw new MetadataExtractionException("Relation IDs mismatch: for relation " + givenId + ", the JDBC " + method + " returns " + extractedId);
        }
    }

    protected @Nullable String escapeRelationIdComponentPattern(@Nullable String s) {
        return s == null || this.escape == null ? s : s.replace("_", this.escape + "_").replace("%", this.escape + "%");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedRelationDefinition getRelation(RelationID id0) throws MetadataExtractionException {
        LogOperation logOperation = new LogOperation();
        DBTypeFactory dbTypeFactory = this.dbParameters.getDBTypeFactory();
        RelationID id = this.getCanonicalRelationId(id0);
        try (ResultSet rs = this.getColumnsResultSet(id);){
            RelationNotFoundInMetadataException relationNotFoundInMetadataException;
            HashMap<RelationID, RelationDefinition.AttributeListBuilder> relations = new HashMap<RelationID, RelationDefinition.AttributeListBuilder>();
            while (rs.next()) {
                logOperation.advanceCounter();
                RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                this.checkSameRelationID(extractedId, id, "getColumns");
                RelationDefinition.AttributeListBuilder builder = relations.computeIfAbsent(extractedId, i -> DatabaseTableDefinition.attributeListBuilder());
                QuotedID attributeId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                boolean isNullable = rs.getInt("NULLABLE") != 0;
                String typeName = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                DBTermType termType = dbTypeFactory.getDBTermType(typeName, columnSize);
                String sqlTypeName = this.extractSQLTypeName(typeName, rs.getInt("DATA_TYPE"), columnSize, () -> rs.getInt("DECIMAL_DIGITS"));
                builder.addAttribute(attributeId, termType, sqlTypeName, isNullable);
            }
            LOGGER.debug("[DB-METADATA] Column info extracted in {} ms/column", (Object)logOperation.getAverageDuration());
            if (relations.entrySet().size() == 1) {
                Map.Entry r = relations.entrySet().iterator().next();
                DatabaseTableDefinition databaseTableDefinition = new DatabaseTableDefinition(this.getAllIDs((RelationID)r.getKey()), (RelationDefinition.AttributeListBuilder)r.getValue());
                return databaseTableDefinition;
            }
            if (relations.isEmpty()) {
                relationNotFoundInMetadataException = new RelationNotFoundInMetadataException(id, this.getRelationIDs());
                throw relationNotFoundInMetadataException;
            }
            relationNotFoundInMetadataException = new MetadataExtractionException("Cannot resolve ambiguous relation id: " + id + ": " + relations.keySet());
            throw relationNotFoundInMetadataException;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected ResultSet getColumnsResultSet(RelationID id) throws SQLException {
        return this.metadata.getColumns(this.getRelationCatalog(id), this.escapeRelationIdComponentPattern(this.getRelationSchema(id)), this.escapeRelationIdComponentPattern(this.getRelationName(id)), null);
    }

    protected String extractSQLTypeName(String typeName, int jdbcType, int columnSize, PrecisionSupplier precisionSupplier) throws SQLException {
        switch (jdbcType) {
            case -9: 
            case 1: 
            case 12: {
                return columnSize != 0 ? typeName + "(" + columnSize + ")" : typeName;
            }
            case 2: 
            case 3: {
                int decimalDigits = precisionSupplier.getPrecision();
                if (columnSize == 0) {
                    return typeName;
                }
                if (decimalDigits == 0) {
                    return typeName + "(" + columnSize + ")";
                }
                return typeName + "(" + columnSize + ", " + decimalDigits + ")";
            }
        }
        return typeName;
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
        try {
            this.insertPrimaryKey(relation);
            this.insertUniqueAttributes(relation);
            this.insertForeignKeys(relation, metadataLookup);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected boolean isPrimaryKeyDisabled(RelationID id, String primaryKeyId) {
        return false;
    }

    protected ResultSet getPrimaryKeysResultSet(String catalog, String schema, String name) throws SQLException {
        return this.metadata.getPrimaryKeys(catalog, schema, name);
    }

    private void insertPrimaryKey(NamedRelationDefinition relation) throws MetadataExtractionException, SQLException {
        LogOperation logOperation;
        block12: {
            logOperation = new LogOperation();
            RelationID id = this.getCanonicalRelationId(relation.getID());
            try (ResultSet rs = this.getPrimaryKeysResultSet(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
                HashMap<Integer, QuotedID> primaryKeyAttributes = new HashMap<Integer, QuotedID>();
                String currentPkName = null;
                while (rs.next()) {
                    logOperation.advanceCounter();
                    RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                    this.checkSameRelationID(extractedId, id, "getPrimaryKeys");
                    String pkName = rs.getString("PK_NAME");
                    if (currentPkName != null && pkName != null && !currentPkName.equals(pkName)) {
                        throw new MetadataExtractionException("Two primary keys for the same table " + id + ": " + currentPkName + " and " + pkName);
                    }
                    currentPkName = pkName;
                    QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                    short seq = rs.getShort("KEY_SEQ");
                    QuotedID previous = primaryKeyAttributes.put(Integer.valueOf(seq), attrId);
                    if (previous == null) continue;
                    throw new MetadataExtractionException("Duplicate attribute " + previous + " in the primary key " + currentPkName + " for " + id);
                }
                if (primaryKeyAttributes.isEmpty()) break block12;
                if (currentPkName != null && this.isPrimaryKeyDisabled(id, currentPkName)) {
                    LOGGER.error("WARNING: primary key {} in table {} is disabled and will not be used in optimizations.", currentPkName, (Object)id);
                    break block12;
                }
                try {
                    FunctionalDependency.Builder builder = UniqueConstraint.primaryKeyBuilder((NamedRelationDefinition)relation, currentPkName);
                    for (int i = 1; i <= primaryKeyAttributes.size(); ++i) {
                        builder.addDeterminant((QuotedID)primaryKeyAttributes.get(i));
                    }
                    builder.build();
                }
                catch (AttributeNotFoundException e) {
                    throw new MetadataExtractionException((Exception)((Object)e));
                }
            }
        }
        LOGGER.debug("[DB-METADATA] Primary key(s) extracted in {} ms/column", (Object)logOperation.getAverageDuration());
    }

    protected boolean isUniqueConstraintDisabled(RelationID id, String constraintId) {
        return false;
    }

    protected ResultSet getIndexInfoResultSet(String catalog, String schema, String name) throws SQLException {
        return this.metadata.getIndexInfo(catalog, schema, name, true, true);
    }

    private void insertUniqueAttributes(NamedRelationDefinition relation) throws MetadataExtractionException, SQLException {
        LogOperation logOperation = new LogOperation();
        RelationID id = this.getCanonicalRelationId(relation.getID());
        try (ResultSet rs = this.getIndexInfoResultSet(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
            FunctionalDependency.Builder builder = null;
            ArrayList<String> columnsNotFound = new ArrayList<String>();
            String constraintId = null;
            while (rs.next()) {
                logOperation.advanceCounter();
                RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                this.checkSameRelationID(extractedId, id, "getIndexInfo");
                if (rs.getShort("TYPE") == 0) {
                    this.createUniqueConstraint(id, builder, constraintId, columnsNotFound);
                    builder = null;
                    continue;
                }
                if (rs.getShort("ORDINAL_POSITION") == 1) {
                    this.createUniqueConstraint(id, builder, constraintId, columnsNotFound);
                    if (!rs.getBoolean("NON_UNIQUE")) {
                        constraintId = rs.getString("INDEX_NAME");
                        builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)constraintId);
                        columnsNotFound.clear();
                    } else {
                        builder = null;
                    }
                }
                if (builder == null) continue;
                QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                try {
                    builder.addDeterminant(attrId);
                }
                catch (AttributeNotFoundException e) {
                    try {
                        attrId = this.rawIdFactory.createAttributeID("\"" + rs.getString("COLUMN_NAME") + "\"");
                        builder.addDeterminant(attrId);
                    }
                    catch (AttributeNotFoundException ex) {
                        columnsNotFound.add(this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME")).getName());
                    }
                }
            }
            this.createUniqueConstraint(id, builder, constraintId, columnsNotFound);
        }
        LOGGER.debug("[DB-METADATA] Unique constraints extracted in {} ms/column", (Object)logOperation.getAverageDuration());
    }

    private void createUniqueConstraint(RelationID id, FunctionalDependency.Builder builder, String constraintId, List<String> columnsNotFound) {
        if (builder != null) {
            if (constraintId != null && this.isUniqueConstraintDisabled(id, constraintId)) {
                LOGGER.error("WARNING: unique constraint {} in table {} is disabled and will not be used in optimizations.", (Object)constraintId, (Object)id);
            } else if (!columnsNotFound.isEmpty()) {
                LOGGER.error("WARNING: column{} {} not found for the unique index {} (table {}): the constraint will not be used in optimizations.", new Object[]{columnsNotFound.size() == 1 ? "" : "s", String.join((CharSequence)", ", columnsNotFound), constraintId, id});
            } else {
                builder.build();
            }
        }
    }

    protected boolean isForeignKeyDisabled(RelationID id, String constraintId) {
        return false;
    }

    protected ResultSet getImportedKeysResultSet(String catalog, String schema, String name) throws SQLException {
        return this.metadata.getImportedKeys(catalog, schema, name);
    }

    private void insertForeignKeys(NamedRelationDefinition relation, MetadataLookup dbMetadata) throws MetadataExtractionException, SQLException {
        LogOperation logOperation = new LogOperation();
        RelationID id = this.getCanonicalRelationId(relation.getID());
        try (ResultSet rs = this.getImportedKeysResultSet(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
            ForeignKeyConstraint.Builder builder = null;
            String constraintId = null;
            while (rs.next()) {
                logOperation.advanceCounter();
                RelationID extractedId = this.getRelationID(rs, "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME");
                this.checkSameRelationID(extractedId, id, "getImportedKeys");
                RelationID pkId = this.getRelationID(rs, "PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME");
                try {
                    short seq = rs.getShort("KEY_SEQ");
                    if (seq == 1) {
                        this.createForeignKeyConstraint(id, builder, constraintId);
                        constraintId = rs.getString("FK_NAME");
                        NamedRelationDefinition ref = dbMetadata.getRelation(pkId);
                        builder = ForeignKeyConstraint.builder((String)constraintId, (NamedRelationDefinition)relation, (NamedRelationDefinition)ref);
                    }
                    if (builder == null) continue;
                    try {
                        QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("FKCOLUMN_NAME"));
                        QuotedID refAttrId = this.rawIdFactory.createAttributeID(rs.getString("PKCOLUMN_NAME"));
                        builder.add(attrId, refAttrId);
                    }
                    catch (AttributeNotFoundException e) {
                        throw new MetadataExtractionException((Exception)((Object)e));
                    }
                }
                catch (MetadataExtractionException e) {
                    LOGGER.warn("Cannot find table {} for foreign key {}", (Object)pkId, constraintId);
                    builder = null;
                }
            }
            this.createForeignKeyConstraint(id, builder, constraintId);
        }
        LOGGER.debug("[DB-METADATA] Foreign keys extracted in {} ms/column", (Object)logOperation.getAverageDuration());
    }

    private void createForeignKeyConstraint(RelationID id, ForeignKeyConstraint.Builder builder, String constraintId) {
        if (builder != null) {
            if (constraintId != null && this.isForeignKeyDisabled(id, constraintId)) {
                LOGGER.error("WARNING: foreign key {} in table {} is disabled and will not be used in optimizations.", (Object)constraintId, (Object)id);
            } else {
                builder.build();
            }
        }
    }

    public RelationDefinition getBlackBoxView(String query) throws MetadataExtractionException, InvalidQueryException {
        return this.settings.allowRetrievingBlackBoxViewMetadataFromDB() ? this.extractBlackBoxViewByConnectingToDB(query) : this.extractBlackBoxViewWithoutConnectingToDB(query);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected RelationDefinition extractBlackBoxViewByConnectingToDB(String query) throws MetadataExtractionException {
        try (Statement st = this.connection.createStatement();){
            ParserViewDefinition parserViewDefinition;
            block15: {
                ResultSet resultSet = st.executeQuery(this.makeQueryMinimizeResultSet(query));
                try {
                    ResultSetMetaData resultSetMetadata = resultSet.getMetaData();
                    int columnCount = resultSetMetadata.getColumnCount();
                    RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
                    int i = 1;
                    while (i <= columnCount) {
                        int index = i++;
                        QuotedID attributeId = this.rawIdFactory.createAttributeID(resultSetMetadata.getColumnName(index));
                        String typeName = resultSetMetadata.getColumnTypeName(index);
                        int columnSize = resultSetMetadata.getColumnDisplaySize(index);
                        DBTermType termType = this.dbTypeFactory.getDBTermType(typeName, columnSize);
                        String sqlTypeName = this.extractSQLTypeName(typeName, resultSetMetadata.getColumnType(index), columnSize, () -> resultSetMetadata.getPrecision(index));
                        builder.addAttribute(attributeId, termType, sqlTypeName, true);
                    }
                    parserViewDefinition = new ParserViewDefinition(builder, query);
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return parserViewDefinition;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException("Cannot extract metadata for a black-box view. " + e.getMessage(), (Exception)e);
        }
    }

    protected String makeQueryMinimizeResultSet(String query) {
        return String.format("SELECT * FROM (%s) subQ LIMIT 1", query);
    }

    protected RelationDefinition extractBlackBoxViewWithoutConnectingToDB(String query) throws InvalidQueryException {
        ImmutableList attributes;
        try {
            DefaultSelectQueryAttributeExtractor sqae = new DefaultSelectQueryAttributeExtractor((MetadataLookup)this, this.coreSingletons);
            Select select = JSqlParserTools.parse(query, !this.getQuotedIDFactory().supportsSquareBracketQuotation());
            ImmutableMap<QuotedID, ImmutableTerm> attrs = sqae.getRAExpressionAttributes(select).getUnqualifiedAttributes();
            attributes = ImmutableList.copyOf((Collection)attrs.keySet());
        }
        catch (JSQLParserException e) {
            LOGGER.info("FAILED TO PARSE: {} {}", (Object)query, (Object)AbstractDBMetadataProvider.getJSQLParserErrorMessage(query, e));
            ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(this.getQuotedIDFactory());
            attributes = sqae.getAttributes(query);
        }
        catch (UnsupportedSelectQueryException e) {
            ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(this.getQuotedIDFactory());
            attributes = sqae.getAttributes(query);
        }
        return new ParserViewDefinition(attributes, query, this.dbTypeFactory);
    }

    private static String getJSQLParserErrorMessage(String sourceQuery, JSQLParserException e) {
        try {
            Pattern pattern;
            Matcher matcher;
            if (e.getCause() instanceof TokenMgrException && (matcher = (pattern = Pattern.compile("at line (\\d+), column (\\d+)")).matcher(e.getCause().getMessage())).find()) {
                int line = Integer.parseInt(matcher.group(1));
                int col = Integer.parseInt(matcher.group(2));
                String sourceQueryLine = sourceQuery.split("\n")[line - 1];
                int MAX_LENGTH = 40;
                if (sourceQueryLine.length() > 40) {
                    if ((sourceQueryLine = sourceQueryLine.substring(sourceQueryLine.length() - 40)).length() > 80) {
                        sourceQueryLine = sourceQueryLine.substring(0, 80);
                    }
                    col = 40;
                }
                return "FAILED TO PARSE: " + sourceQueryLine + "\n" + Strings.repeat((String)" ", (int)("FAILED TO PARSE: ".length() + col - 2)) + "^\n" + e.getCause();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e.getCause().toString();
    }

    protected abstract RelationID getCanonicalRelationId(RelationID var1) throws MetadataExtractionException;

    protected abstract ImmutableList<RelationID> getAllIDs(RelationID var1);

    protected abstract String getRelationCatalog(RelationID var1);

    protected abstract String getRelationSchema(RelationID var1);

    protected abstract String getRelationName(RelationID var1);

    protected static class LogOperation {
        private final long startTime = System.currentTimeMillis();
        private int count;

        LogOperation() {
        }

        void advanceCounter() {
            ++this.count;
        }

        long getAverageDuration() {
            if (this.count == 0) {
                return 0L;
            }
            long endTime = System.currentTimeMillis();
            return (endTime - this.startTime) / (long)this.count;
        }
    }

    @FunctionalInterface
    protected static interface PrecisionSupplier {
        public int getPrecision() throws SQLException;
    }

    protected static interface DefaultRelationIdComponentsFactory {
        public String[] getDefaultRelationIdComponents(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    protected static interface QuotedIDFactoryFactory {
        public QuotedIDFactory create(DatabaseMetaData var1) throws SQLException;
    }
}

