/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.rdf4j;

import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEvent;
import com.ontotext.metamodel.storage.SchemaNotificationService;
import com.ontotext.metamodel.storage.ServiceIdentity;
import com.ontotext.metamodel.storage.SomlSchemaIdStorage;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.metamodel.storage.rdf4j.BaseRdf4jStorage;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.soaas.common.Resettable;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

public class Rdf4jSomlSchemaIdStorage
extends BaseRdf4jStorage
implements SomlSchemaIdStorage,
Resettable {
    private static final SimpleValueFactory VF = SimpleValueFactory.getInstance();
    private final ServiceIdentity nameProvider;
    private final SchemaNotificationService notificationService;
    private IRI serviceId;

    public Rdf4jSomlSchemaIdStorage(EndpointProvider endpointProvider, SparqlConnectionFactory connectionFactory, ServiceIdentity nameProvider, SchemaNotificationService notificationService) {
        super(endpointProvider, connectionFactory);
        this.nameProvider = nameProvider;
        this.notificationService = notificationService;
    }

    @Override
    protected String getName() {
        return "rdf4j-id-store";
    }

    public Optional<String> getId() throws UnreachableStoreException {
        return this.withConnection(this::getBoundSchema);
    }

    public void setId(String id) throws UnreachableStoreException {
        try {
            Optional<String> entity = this.getId();
            if (entity.filter(Predicate.isEqual(id)).isPresent()) {
                return;
            }
            String opResult = this.withTransaction(connection -> {
                entity.ifPresent(this.removeServiceBinding(connection));
                if (id != null) {
                    this.addServiceBinding(connection, id);
                    return id;
                }
                return null;
            });
            this.notificationService.notifyListeners((SchemaEvent)new SchemaBindingChanged(opResult, true));
        }
        catch (UnreachableStoreException use) {
            throw use;
        }
        catch (SomlStoreException sse) {
            throw new IllegalStateException("Could not bind schema: " + id, sse);
        }
    }

    private void addServiceBinding(SparqlConnection connection, String newSchemaId) {
        connection.addStatement(VF.createStatement((Resource)this.getServiceId(), Constants.BOUND_SCHEMA, (Value)SimpleValueFactory.getInstance().createLiteral(newSchemaId), (Resource)Constants.ID_STORE_CONTEXT));
    }

    private Consumer<String> removeServiceBinding(SparqlConnection connection) {
        return previousBoundId -> connection.removeStatements((Resource)this.getServiceId(), Constants.BOUND_SCHEMA, (Value)SimpleValueFactory.getInstance().createLiteral(previousBoundId), new Resource[]{Constants.ID_STORE_CONTEXT});
    }

    @NotNull
    private Optional<String> getBoundSchema(SparqlConnection connection) {
        return connection.stream((Resource)this.getServiceId(), Constants.BOUND_SCHEMA, null, new Resource[]{Constants.ID_STORE_CONTEXT}).map(Statement::getObject).map(Rdf4jValueConverter::convert).map(Objects::toString).findFirst();
    }

    private IRI getServiceId() {
        if (this.serviceId == null) {
            this.serviceId = VF.createIRI("http://www.ontotext.com/semantic-object/service#" + this.nameProvider.getName());
        }
        return this.serviceId;
    }

    public void reset() {
        try {
            this.setId(null);
        }
        catch (UnreachableStoreException use) {
            throw new IllegalStateException(use);
        }
    }
}

