/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.rdf4j;

import com.ontotext.sparql.ChainingRepositoryCreator;
import com.ontotext.sparql.InMemoryRepositoryCreator;
import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.TemplatedRepositoryCreator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class DefaultRepositoryCreator
extends ChainingRepositoryCreator {
    private static final String REPO_ID = "%repo-id%";
    private static final String GDB_10_TEMPLATE = "repository-template-10.ttl";
    private static final String GDB_11_TEMPLATE = "repository-template-11.ttl";

    public DefaultRepositoryCreator() {
        super(DefaultRepositoryCreator.buildChain());
    }

    private static List<RepositoryCreator> buildChain() {
        return Arrays.asList(new TemplatedRepositoryCreator(DefaultRepositoryCreator.loadRepoTemplate(GDB_11_TEMPLATE), REPO_ID), new TemplatedRepositoryCreator(DefaultRepositoryCreator.loadRepoTemplate(GDB_10_TEMPLATE), REPO_ID), new InMemoryRepositoryCreator());
    }

    private static String loadRepoTemplate(String template) {
        String string;
        block9: {
            InputStream inputStream = DefaultRepositoryCreator.class.getClassLoader().getResourceAsStream(template);
            try {
                if (inputStream == null) {
                    throw new IllegalStateException("Could not load internal resource: " + template);
                }
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Could not load internal resource: " + template);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

