/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class ToolExecutionResult {
    private final boolean isError;
    private final Object result;
    private final String resultText;

    public ToolExecutionResult(Builder builder) {
        this.isError = builder.isError;
        this.result = builder.result;
        this.resultText = (String)ValidationUtils.ensureNotNull((Object)builder.resultText, (String)"resultText");
    }

    public boolean isError() {
        return this.isError;
    }

    public Object result() {
        return this.result;
    }

    public String resultText() {
        return this.resultText;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToolExecutionResult that = (ToolExecutionResult)object;
        return this.isError == that.isError && Objects.equals(this.result, that.result) && Objects.equals(this.resultText, that.resultText);
    }

    public int hashCode() {
        return Objects.hash(this.isError, this.result, this.resultText);
    }

    public String toString() {
        return "ToolExecutionResult{isError=" + this.isError + ", result=" + String.valueOf(this.result) + ", resultText='" + this.resultText + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isError;
        private Object result;
        private String resultText;

        public Builder isError(boolean isError) {
            this.isError = isError;
            return this;
        }

        public Builder result(Object result) {
            this.result = result;
            return this;
        }

        public Builder resultText(String resultText) {
            this.resultText = resultText;
            return this;
        }

        public ToolExecutionResult build() {
            return new ToolExecutionResult(this);
        }
    }
}

