/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.guardrail.InputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.observability.api.event.AiServiceCompletedEvent;
import dev.langchain4j.observability.api.event.AiServiceErrorEvent;
import dev.langchain4j.observability.api.event.AiServiceEvent;
import dev.langchain4j.observability.api.event.AiServiceResponseReceivedEvent;
import dev.langchain4j.observability.api.event.AiServiceStartedEvent;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.AiServiceTokenStreamParameters;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.InternalReflectionVariableResolver;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.service.Moderate;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.TypeUtils;
import dev.langchain4j.service.UserMessage;
import dev.langchain4j.service.UserName;
import dev.langchain4j.service.V;
import dev.langchain4j.service.guardrail.GuardrailService;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import dev.langchain4j.service.output.ServiceOutputParser;
import dev.langchain4j.service.tool.ToolServiceContext;
import dev.langchain4j.service.tool.ToolServiceResult;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.services.TokenStreamAdapter;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Internal
class DefaultAiServices<T>
extends AiServices<T> {
    private final ServiceOutputParser serviceOutputParser = new ServiceOutputParser();
    private final Collection<TokenStreamAdapter> tokenStreamAdapters = ServiceHelper.loadFactories(TokenStreamAdapter.class);

    DefaultAiServices(AiServiceContext context) {
        super(context);
    }

    static void validateParameters(Class<?> aiServiceClass, Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length < 2) {
            return;
        }
        boolean invocationParametersExist = false;
        for (Parameter parameter : parameters) {
            V v = parameter.getAnnotation(V.class);
            UserMessage userMessage = parameter.getAnnotation(UserMessage.class);
            MemoryId memoryId = parameter.getAnnotation(MemoryId.class);
            UserName userName = parameter.getAnnotation(UserName.class);
            if (InvocationParameters.class.isAssignableFrom(parameter.getType())) {
                if (invocationParametersExist) {
                    throw IllegalConfigurationException.illegalConfiguration("There can be at most one parameter of type %s", InvocationParameters.class.getName());
                }
                invocationParametersExist = true;
                continue;
            }
            if (userMessage != null || v != null || memoryId != null || userName != null) continue;
            throw IllegalConfigurationException.illegalConfiguration("The parameter '%s' in the method '%s' of the class %s must be annotated with either %s, %s, %s, or %s, or it should be of type %s", parameter.getName(), method.getName(), aiServiceClass.getName(), UserMessage.class.getName(), V.class.getName(), MemoryId.class.getName(), UserName.class.getName(), InvocationParameters.class.getName());
        }
    }

    private void validateContextMemory() {
        if (!this.context.hasChatMemory() && ChatMemoryAccess.class.isAssignableFrom(this.context.aiServiceClass)) {
            throw IllegalConfigurationException.illegalConfiguration("In order to have a service implementing ChatMemoryAccess, please configure the ChatMemoryProvider on the '%s'.", this.context.aiServiceClass.getName());
        }
    }

    private void validateMethods() {
        for (Method method : this.context.aiServiceClass.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (method.isAnnotationPresent(Moderate.class) && this.context.moderationModel == null) {
                throw IllegalConfigurationException.illegalConfiguration("The @Moderate annotation is present, but the moderationModel is not set up. Please ensure a valid moderationModel is configured before using the @Moderate annotation.");
            }
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                throw IllegalConfigurationException.illegalConfiguration("'%s' is not a supported return type of an AI Service method", returnType.getName());
            }
            if (returnType == Result.class || returnType == List.class || returnType == Set.class) {
                TypeUtils.validateReturnTypesAreProperlyParametrized(method.getName(), method.getGenericReturnType());
            }
            if (this.context.hasChatMemory()) continue;
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.isAnnotationPresent(MemoryId.class)) continue;
                throw IllegalConfigurationException.illegalConfiguration("In order to use @MemoryId, please configure the ChatMemoryProvider on the '%s'.", this.context.aiServiceClass.getName());
            }
        }
    }

    protected void validate() {
        this.performBasicValidation();
        this.validateContextMemory();
        this.validateMethods();
    }

    private Object handleChatMemoryAccess(Method method, Object[] args) {
        return switch (method.getName()) {
            case "getChatMemory" -> this.context.chatMemoryService.getChatMemory(args[0]);
            case "evictChatMemory" -> Boolean.valueOf(this.context.chatMemoryService.evictChatMemory(args[0]) != null);
            default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + method.getName());
        };
    }

    @Override
    public T build() {
        this.validate();
        Object proxyInstance = Proxy.newProxyInstance(this.context.aiServiceClass.getClassLoader(), new Class[]{this.context.aiServiceClass}, new InvocationHandler(){
            private final ExecutorService executor = Executors.newCachedThreadPool();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.isDefault()) {
                    return InvocationHandler.invokeDefault(proxy, method, args);
                }
                if (method.getDeclaringClass() == Object.class) {
                    switch (method.getName()) {
                        case "equals": {
                            return proxy == args[0];
                        }
                        case "hashCode": {
                            return System.identityHashCode(proxy);
                        }
                        case "toString": {
                            return DefaultAiServices.this.context.aiServiceClass.getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                        }
                    }
                    throw new IllegalStateException("Unexpected Object method: " + String.valueOf(method));
                }
                if (method.getDeclaringClass() == ChatMemoryAccess.class) {
                    return DefaultAiServices.this.handleChatMemoryAccess(method, args);
                }
                DefaultAiServices.validateParameters(DefaultAiServices.this.context.aiServiceClass, method);
                InvocationParameters invocationParameters = this.findInvocationParams(args, method.getParameters()).orElseGet(InvocationParameters::new);
                InvocationContext invocationContext = InvocationContext.builder().invocationId(UUID.randomUUID()).interfaceName(DefaultAiServices.this.context.aiServiceClass.getName()).methodName(method.getName()).methodArguments(args != null ? Arrays.asList(args) : List.of()).chatMemoryId(DefaultAiServices.findMemoryId(method, args).orElse("default")).invocationParameters(invocationParameters).timestampNow().build();
                try {
                    return this.invoke(method, args, invocationContext);
                }
                catch (Exception ex) {
                    DefaultAiServices.this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceErrorEvent.builder().invocationContext(invocationContext).error((Throwable)ex).build());
                    throw ex;
                }
            }

            public Object invoke(Method method, Object[] args, InvocationContext invocationContext) {
                Optional<List<Content>> maybeContents;
                Object memoryId = invocationContext.chatMemoryId();
                ChatMemory chatMemory = DefaultAiServices.this.context.hasChatMemory() ? DefaultAiServices.this.context.chatMemoryService.getOrCreateChatMemory(memoryId) : null;
                Optional<dev.langchain4j.data.message.SystemMessage> systemMessage = DefaultAiServices.this.prepareSystemMessage(memoryId, method, args);
                String userMessageTemplate = DefaultAiServices.getUserMessageTemplate(method, args);
                Map<String, Object> variables = InternalReflectionVariableResolver.findTemplateVariables(userMessageTemplate, method, args);
                dev.langchain4j.data.message.UserMessage userMessage = DefaultAiServices.prepareUserMessage(method, args, userMessageTemplate, variables);
                DefaultAiServices.this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceStartedEvent.builder().invocationContext(invocationContext).systemMessage(systemMessage).userMessage(userMessage).build());
                AugmentationResult augmentationResult = null;
                if (DefaultAiServices.this.context.retrievalAugmentor != null) {
                    List chatMemoryMessages = chatMemory != null ? chatMemory.messages() : null;
                    Metadata metadata = Metadata.builder().chatMessage((ChatMessage)userMessage).chatMemory(chatMemoryMessages).invocationContext(invocationContext).build();
                    AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)userMessage, metadata);
                    augmentationResult = DefaultAiServices.this.context.retrievalAugmentor.augment(augmentationRequest);
                    userMessage = (dev.langchain4j.data.message.UserMessage)augmentationResult.chatMessage();
                }
                GuardrailRequestParams commonGuardrailParam = GuardrailRequestParams.builder().chatMemory(chatMemory).augmentationResult(augmentationResult).userMessageTemplate(userMessageTemplate).invocationContext(invocationContext).aiServiceListenerRegistrar(DefaultAiServices.this.context.eventListenerRegistrar).variables(variables).build();
                userMessage = DefaultAiServices.this.invokeInputGuardrails(DefaultAiServices.this.context.guardrailService(), method, userMessage, commonGuardrailParam);
                Type returnType = method.getGenericReturnType();
                boolean streaming = returnType == TokenStream.class || this.canAdaptTokenStreamTo(returnType);
                boolean supportsJsonSchema = this.supportsJsonSchema();
                Optional<Object> jsonSchema = Optional.empty();
                if (supportsJsonSchema && !streaming) {
                    jsonSchema = DefaultAiServices.this.serviceOutputParser.jsonSchema(returnType);
                }
                if (!(supportsJsonSchema && !jsonSchema.isEmpty() || streaming)) {
                    userMessage = this.appendOutputFormatInstructions(returnType, userMessage);
                }
                if ((maybeContents = DefaultAiServices.findContents(method, args)).isPresent()) {
                    ArrayList<Content> allContents = new ArrayList<Content>();
                    for (Content content : maybeContents.get()) {
                        if (content == null) {
                            allContents.addAll(userMessage.contents());
                            continue;
                        }
                        allContents.add(content);
                    }
                    userMessage = dev.langchain4j.data.message.UserMessage.from((String)userMessage.name(), allContents);
                }
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
                if (DefaultAiServices.this.context.hasChatMemory()) {
                    systemMessage.ifPresent(arg_0 -> ((ChatMemory)chatMemory).add(arg_0));
                    chatMemory.add((ChatMessage)userMessage);
                    messages.addAll(chatMemory.messages());
                } else {
                    systemMessage.ifPresent(messages::add);
                    messages.add((ChatMessage)userMessage);
                }
                Future<Moderation> moderationFuture = this.triggerModerationIfNeeded(method, messages);
                ToolServiceContext toolServiceContext = DefaultAiServices.this.context.toolService.createContext(invocationContext, userMessage);
                if (streaming) {
                    AiServiceTokenStreamParameters tokenStreamParameters = AiServiceTokenStreamParameters.builder().messages(messages).toolSpecifications(toolServiceContext.toolSpecifications()).toolExecutors(toolServiceContext.toolExecutors()).toolArgumentsErrorHandler(DefaultAiServices.this.context.toolService.argumentsErrorHandler()).toolExecutionErrorHandler(DefaultAiServices.this.context.toolService.executionErrorHandler()).toolExecutor(DefaultAiServices.this.context.toolService.executor()).retrievedContents(augmentationResult != null ? augmentationResult.contents() : null).context(DefaultAiServices.this.context).invocationContext(invocationContext).commonGuardrailParams(commonGuardrailParam).methodKey(method).build();
                    AiServiceTokenStream tokenStream = new AiServiceTokenStream(tokenStreamParameters);
                    if (returnType == TokenStream.class) {
                        return tokenStream;
                    }
                    return this.adapt(tokenStream, returnType);
                }
                ResponseFormat responseFormat = null;
                if (supportsJsonSchema && jsonSchema.isPresent()) {
                    responseFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema((JsonSchema)jsonSchema.get()).build();
                }
                ChatRequestParameters parameters = ChatRequestParameters.builder().toolSpecifications(toolServiceContext.toolSpecifications()).responseFormat(responseFormat).build();
                ChatRequest chatRequest = DefaultAiServices.this.context.chatRequestTransformer.apply(ChatRequest.builder().messages(messages).parameters(parameters).build(), memoryId);
                ChatExecutor chatExecutor = ChatExecutor.builder((ChatModel)DefaultAiServices.this.context.chatModel).chatRequest(chatRequest).build();
                ChatResponse chatResponse = chatExecutor.execute();
                DefaultAiServices.this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceResponseReceivedEvent.builder().invocationContext(invocationContext).response(chatResponse).build());
                AiServices.verifyModerationIfNeeded(moderationFuture);
                boolean isReturnTypeResult = TypeUtils.typeHasRawClass(returnType, Result.class);
                ToolServiceResult toolServiceResult = DefaultAiServices.this.context.toolService.executeInferenceAndToolsLoop(chatResponse, parameters, messages, DefaultAiServices.this.context.chatModel, chatMemory, invocationContext, toolServiceContext.toolExecutors(), isReturnTypeResult, DefaultAiServices.this.context.eventListenerRegistrar);
                if (toolServiceResult.immediateToolReturn() && isReturnTypeResult) {
                    Result<Object> result = Result.builder().content(null).tokenUsage(toolServiceResult.aggregateTokenUsage()).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(FinishReason.TOOL_EXECUTION).toolExecutions(toolServiceResult.toolExecutions()).intermediateResponses(toolServiceResult.intermediateResponses()).finalResponse(toolServiceResult.finalResponse()).build();
                    DefaultAiServices.this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceCompletedEvent.builder().invocationContext(invocationContext).result(result).build());
                    return result;
                }
                ChatResponse aggregateResponse = toolServiceResult.aggregateResponse();
                Object response = DefaultAiServices.this.invokeOutputGuardrails(DefaultAiServices.this.context.guardrailService(), method, aggregateResponse, chatExecutor, commonGuardrailParam);
                if (response != null && TypeUtils.typeHasRawClass(returnType, response.getClass())) {
                    DefaultAiServices.this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceCompletedEvent.builder().invocationContext(invocationContext).result(response).build());
                    return response;
                }
                Result<Object> parsedResponse = DefaultAiServices.this.serviceOutputParser.parse((ChatResponse)response, returnType);
                Result<Object> actualResponse = isReturnTypeResult ? Result.builder().content(parsedResponse).tokenUsage(toolServiceResult.aggregateTokenUsage()).sources(augmentationResult == null ? null : augmentationResult.contents()).finishReason(toolServiceResult.finalResponse().finishReason()).toolExecutions(toolServiceResult.toolExecutions()).intermediateResponses(toolServiceResult.intermediateResponses()).finalResponse(toolServiceResult.finalResponse()).build() : parsedResponse;
                DefaultAiServices.this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceCompletedEvent.builder().invocationContext(invocationContext).result((Object)actualResponse).build());
                return actualResponse;
            }

            private Optional<InvocationParameters> findInvocationParams(Object[] args, Parameter[] params) {
                if (args == null) {
                    return Optional.empty();
                }
                for (int i = 0; i < params.length; ++i) {
                    Parameter parameter = params[i];
                    if (!InvocationParameters.class.isAssignableFrom(parameter.getType())) continue;
                    InvocationParameters invocationParameters = (InvocationParameters)args[i];
                    ValidationUtils.ensureNotNull((Object)invocationParameters, (String)"InvocationParameters");
                    return Optional.of(invocationParameters);
                }
                return Optional.empty();
            }

            private boolean canAdaptTokenStreamTo(Type returnType) {
                for (TokenStreamAdapter tokenStreamAdapter : DefaultAiServices.this.tokenStreamAdapters) {
                    if (!tokenStreamAdapter.canAdaptTokenStreamTo(returnType)) continue;
                    return true;
                }
                return false;
            }

            private Object adapt(TokenStream tokenStream, Type returnType) {
                for (TokenStreamAdapter tokenStreamAdapter : DefaultAiServices.this.tokenStreamAdapters) {
                    if (!tokenStreamAdapter.canAdaptTokenStreamTo(returnType)) continue;
                    return tokenStreamAdapter.adapt(tokenStream);
                }
                throw new IllegalStateException("Can't find suitable TokenStreamAdapter");
            }

            private boolean supportsJsonSchema() {
                return DefaultAiServices.this.context.chatModel != null && DefaultAiServices.this.context.chatModel.supportedCapabilities().contains(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
            }

            private dev.langchain4j.data.message.UserMessage appendOutputFormatInstructions(Type returnType, dev.langchain4j.data.message.UserMessage userMessage) {
                String outputFormatInstructions = DefaultAiServices.this.serviceOutputParser.outputFormatInstructions(returnType);
                String text = userMessage.singleText() + outputFormatInstructions;
                userMessage = Utils.isNotNullOrBlank((String)userMessage.name()) ? dev.langchain4j.data.message.UserMessage.from((String)userMessage.name(), (String)text) : dev.langchain4j.data.message.UserMessage.from((String)text);
                return userMessage;
            }

            private Future<Moderation> triggerModerationIfNeeded(Method method, List<ChatMessage> messages) {
                if (method.isAnnotationPresent(Moderate.class)) {
                    return this.executor.submit(() -> {
                        List<ChatMessage> messagesToModerate = AiServices.removeToolMessages(messages);
                        return (Moderation)DefaultAiServices.this.context.moderationModel.moderate(messagesToModerate).content();
                    });
                }
                return null;
            }
        });
        return (T)proxyInstance;
    }

    private dev.langchain4j.data.message.UserMessage invokeInputGuardrails(GuardrailService guardrailService, Method method, dev.langchain4j.data.message.UserMessage userMessage, GuardrailRequestParams commonGuardrailParams) {
        if (guardrailService.hasInputGuardrails(method)) {
            InputGuardrailRequest inputGuardrailRequest = InputGuardrailRequest.builder().userMessage(userMessage).commonParams(commonGuardrailParams).build();
            return guardrailService.executeGuardrails(method, inputGuardrailRequest);
        }
        return userMessage;
    }

    private <T> T invokeOutputGuardrails(GuardrailService guardrailService, Method method, ChatResponse responseFromLLM, ChatExecutor chatExecutor, GuardrailRequestParams commonGuardrailParams) {
        if (guardrailService.hasOutputGuardrails(method)) {
            OutputGuardrailRequest outputGuardrailRequest = OutputGuardrailRequest.builder().responseFromLLM(responseFromLLM).chatExecutor(chatExecutor).requestParams(commonGuardrailParams).build();
            return guardrailService.executeGuardrails(method, outputGuardrailRequest);
        }
        return (T)responseFromLLM;
    }

    private Optional<dev.langchain4j.data.message.SystemMessage> prepareSystemMessage(Object memoryId, Method method, Object[] args) {
        return this.findSystemMessageTemplate(memoryId, method).map(systemMessageTemplate -> PromptTemplate.from((String)systemMessageTemplate).apply(InternalReflectionVariableResolver.findTemplateVariables(systemMessageTemplate, method, args)).toSystemMessage());
    }

    private Optional<String> findSystemMessageTemplate(Object memoryId, Method method) {
        SystemMessage annotation = method.getAnnotation(SystemMessage.class);
        if (annotation != null) {
            return Optional.of(DefaultAiServices.getTemplate(method, "System", annotation.fromResource(), annotation.value(), annotation.delimiter()));
        }
        return this.context.systemMessageProvider.apply(memoryId);
    }

    private static dev.langchain4j.data.message.UserMessage prepareUserMessage(Method method, Object[] args, String userMessageTemplate, Map<String, Object> variables) {
        Prompt prompt = PromptTemplate.from((String)userMessageTemplate).apply(variables);
        Optional<String> maybeUserName = DefaultAiServices.findUserName(method.getParameters(), args);
        return maybeUserName.map(userName -> dev.langchain4j.data.message.UserMessage.from((String)userName, (String)prompt.text())).orElseGet(() -> ((Prompt)prompt).toUserMessage());
    }

    private static String getUserMessageTemplate(Method method, Object[] args) {
        Optional<String> templateFromMethodAnnotation = DefaultAiServices.findUserMessageTemplateFromMethodAnnotation(method);
        Optional<String> templateFromParameterAnnotation = DefaultAiServices.findUserMessageTemplateFromAnnotatedParameter(method.getParameters(), args);
        if (templateFromMethodAnnotation.isPresent() && templateFromParameterAnnotation.isPresent()) {
            throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' has multiple @UserMessage annotations. Please use only one.", method.getName());
        }
        if (templateFromMethodAnnotation.isPresent()) {
            return templateFromMethodAnnotation.get();
        }
        if (templateFromParameterAnnotation.isPresent()) {
            return templateFromParameterAnnotation.get();
        }
        Optional<String> templateFromTheOnlyArgument = DefaultAiServices.findUserMessageTemplateFromTheOnlyArgument(method.getParameters(), args);
        if (templateFromTheOnlyArgument.isPresent()) {
            return templateFromTheOnlyArgument.get();
        }
        throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' does not have a user message defined.", method.getName());
    }

    private static Optional<String> findUserMessageTemplateFromMethodAnnotation(Method method) {
        return Optional.ofNullable(method.getAnnotation(UserMessage.class)).map(a -> DefaultAiServices.getTemplate(method, "User", a.fromResource(), a.value(), a.delimiter()));
    }

    private static Optional<String> findUserMessageTemplateFromAnnotatedParameter(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserMessage.class) || args[i] instanceof Content || DefaultAiServices.isListOfContents(args[i])) continue;
            return Optional.of(InternalReflectionVariableResolver.asString(args[i]));
        }
        return Optional.empty();
    }

    private static Optional<String> findUserMessageTemplateFromTheOnlyArgument(Parameter[] parameters, Object[] args) {
        if (parameters != null && parameters.length == 1 && parameters[0].getAnnotations().length == 0) {
            return Optional.of(InternalReflectionVariableResolver.asString(args[0]));
        }
        return Optional.empty();
    }

    private static Optional<String> findUserName(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserName.class)) continue;
            return Optional.of(args[i].toString());
        }
        return Optional.empty();
    }

    private static Optional<List<Content>> findContents(Method method, Object[] args) {
        ArrayList<Content> contents = new ArrayList<Content>();
        if (DefaultAiServices.findUserMessageTemplateFromMethodAnnotation(method).isPresent()) {
            contents.add(null);
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(UserMessage.class)) continue;
            if (args[i] instanceof Content) {
                contents.add((Content)args[i]);
                continue;
            }
            if (DefaultAiServices.isListOfContents(args[i])) {
                contents.addAll((List)args[i]);
                continue;
            }
            contents.add(null);
        }
        if (contents.stream().filter(Objects::isNull).count() > 1L) {
            throw IllegalConfigurationException.illegalConfiguration("Error: The method '%s' has multiple @UserMessage for text content. Please use only one.", method.getName());
        }
        return contents.isEmpty() ? Optional.empty() : Optional.of(contents);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isListOfContents(Object o) {
        if (!(o instanceof List)) return false;
        List list = (List)o;
        if (!list.stream().allMatch(Content.class::isInstance)) return false;
        return true;
    }

    private static String getTemplate(Method method, String type, String resource, String[] value, String delimiter) {
        String messageTemplate;
        if (!resource.trim().isEmpty()) {
            messageTemplate = DefaultAiServices.getResourceText(method.getDeclaringClass(), resource);
            if (messageTemplate == null) {
                throw IllegalConfigurationException.illegalConfiguration("@%sMessage's resource '%s' not found", type, resource);
            }
        } else {
            messageTemplate = String.join((CharSequence)delimiter, value);
        }
        if (messageTemplate.trim().isEmpty()) {
            throw IllegalConfigurationException.illegalConfiguration("@%sMessage's template cannot be empty", type);
        }
        return messageTemplate;
    }

    private static String getResourceText(Class<?> clazz, String resource) {
        InputStream inputStream = clazz.getResourceAsStream(resource);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream("/" + resource);
        }
        return DefaultAiServices.getText(inputStream);
    }

    private static String getText(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(inputStream);){
            Scanner s = scanner.useDelimiter("\\A");
            try {
                String string;
                String string2 = string = s.hasNext() ? s.next() : "";
                if (s != null) {
                    s.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static Optional<Object> findMemoryId(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(MemoryId.class)) continue;
            Object memoryId = args[i];
            if (memoryId == null) {
                throw Exceptions.illegalArgument((String)"The value of parameter '%s' annotated with @MemoryId in method '%s' must not be null", (Object[])new Object[]{parameters[i].getName(), method.getName()});
            }
            return Optional.of(memoryId);
        }
        return Optional.empty();
    }
}

