/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.processing;

import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.logging.LoggingContext;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.TaskDispatcher;
import com.ontotext.tasks.processing.TaskProvider;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class TaskRunner<T extends Task, D extends DataEndpoint>
implements Runnable {
    private static final Logger LOGGER = Loggers.tasksLogger();
    private final TaskProvider<T> taskProvider;
    private final D dataEndpoint;
    private final TaskDispatcher<T, D> taskCaller;
    private final JobContext jobContext;
    private final Consumer<JobContext> onComplete;
    private final CountDownLatch done;

    TaskRunner(TaskProvider<T> taskProvider, D dataEndpoint, TaskDispatcher<T, D> taskCaller, JobContext jobContext, Consumer<JobContext> onComplete) {
        this.taskProvider = taskProvider;
        this.dataEndpoint = dataEndpoint;
        this.taskCaller = Objects.requireNonNull(taskCaller);
        this.jobContext = jobContext;
        this.onComplete = onComplete;
        this.done = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoggingContext.setRequestId((String)StringUtils.substringAfterLast((String)this.jobContext.getJobId(), (int)47));
        try {
            T task;
            while (TaskRunner.isNotRequestedToTerminate() && (task = this.getNextTask()) != null) {
                this.processTask(task);
            }
        }
        finally {
            try {
                this.done.countDown();
                if (this.onComplete != null) {
                    this.onComplete.accept(this.jobContext);
                }
                if (!TaskRunner.isNotRequestedToTerminate()) {
                    LOGGER.info("Task processing for {} was terminated by an external request.", (Object)this.jobContext.getJobId());
                }
            }
            finally {
                LoggingContext.clearRequestId();
            }
        }
    }

    private T getNextTask() {
        return this.taskCaller.getNextTask(this.taskProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTask(T task) {
        long start = System.currentTimeMillis();
        try {
            this.taskCaller.dispatch(task, this.dataEndpoint, this.jobContext);
            if (!task.getTaskStatus().isDone()) {
                task.setTaskStatus(Task.TaskStatus.SUCCESS);
            }
            this.updateTaskDuration(task, start);
        }
        catch (RuntimeException re) {
            task.setTaskStatus(Task.TaskStatus.FAIL);
            task.addResult(re.getMessage());
            LOGGER.warn("Task evaluation failed with: {}", (Object)re.getMessage(), (Object)re);
        }
        finally {
            if (TaskRunner.isNotRequestedToTerminate()) {
                this.taskCaller.doneWithTask(this.taskProvider, task);
            }
        }
    }

    private static boolean isNotRequestedToTerminate() {
        return !Thread.currentThread().isInterrupted();
    }

    private void updateTaskDuration(T task, long start) {
        task.setEvaluationDuration(System.currentTimeMillis() - start);
    }

    public void waitUntilDone() {
        try {
            this.done.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOGGER.info("Interrupted while waiting for {} to complete", (Object)this.jobContext.getJobId());
        }
    }
}

