/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.job;

import com.ontotext.tasks.job.JobEvent;
import com.ontotext.tasks.job.JobEventType;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.tasks.job.JobNotifiable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class JobEventNotifier
implements JobNotifiable {
    private List<JobListener> jobListeners = new CopyOnWriteArrayList<JobListener>();

    @Override
    public void addJobListener(JobListener jobListener) {
        this.jobListeners.add(jobListener);
    }

    @Override
    public void removeJobListener(JobListener jobListener) {
        this.jobListeners.remove(jobListener);
    }

    public void notifyListeners(String jobId, String schemaId, String repository, JobEventType eventType) {
        JobEvent event = new JobEvent(jobId, eventType, schemaId, repository);
        this.notifyListeners(event);
    }

    public void notifyListeners(JobEvent event) {
        for (JobListener jobListener : this.jobListeners) {
            jobListener.onEvent(event);
        }
    }
}

