/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks;

import com.ontotext.soaas.common.concurrent.MonitoredOperationInfo;
import com.ontotext.soaas.common.concurrent.MonitoredService;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.TaskProcessor;
import com.ontotext.tasks.TaskProcessorFactory;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.MonitoredRetryingTaskDispatcher;
import com.ontotext.tasks.processing.TaskDispatcher;
import com.ontotext.tasks.processing.TaskProviderCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MonitoredTaskProcessorFactory
implements TaskProcessorFactory,
MonitoredService {
    private final TaskProcessorFactory delegate;
    private final String operationName;
    private Map<String, MonitoredOperationInfo> status = new ConcurrentHashMap<String, MonitoredOperationInfo>();

    public MonitoredTaskProcessorFactory(TaskProcessorFactory delegate, String operationName) {
        this.delegate = delegate;
        this.operationName = operationName;
    }

    public List<MonitoredOperationInfo> getFullInfo() {
        return new ArrayList<MonitoredOperationInfo>(this.status.values());
    }

    public List<MonitoredOperationInfo> getSummaryInfo() {
        return new ArrayList<MonitoredOperationInfo>(this.status.values());
    }

    @Override
    public TaskProcessor createProcessor() {
        return new MonitoredValidationTaskProcessor(this.delegate.createProcessor(), this.status, this.operationName);
    }

    private static class MonitoredValidationTaskProcessor
    implements TaskProcessor {
        private final TaskProcessor delegate;
        private final Map<String, MonitoredOperationInfo> statusMap;
        private final String operationName;

        private MonitoredValidationTaskProcessor(TaskProcessor delegate, Map<String, MonitoredOperationInfo> statusMap, String operationName) {
            this.delegate = delegate;
            this.statusMap = statusMap;
            this.operationName = operationName;
        }

        @Override
        public <T extends Task> void start(JobContext jobContext, TaskProviderCallback<T> taskProviderCallback, TaskDispatcher<T, DataEndpoint> taskDispatcher) {
            String jobId = jobContext.getJobId();
            MonitoredRetryingTaskDispatcher<T, DataEndpoint> monitoredTaskDispatcher = taskDispatcher instanceof MonitoredRetryingTaskDispatcher ? (MonitoredRetryingTaskDispatcher<T, DataEndpoint>)taskDispatcher : new MonitoredRetryingTaskDispatcher<T, DataEndpoint>(taskDispatcher);
            this.statusMap.put(jobId, new MonitoredOperationInfo(this.operationName, jobContext.getSchemaId(), Timer.start(), null, null, monitoredTaskDispatcher::getFullInfo));
            try {
                this.delegate.start(jobContext, taskProviderCallback, monitoredTaskDispatcher);
            }
            catch (RuntimeException re) {
                this.statusMap.remove(jobId);
                throw re;
            }
        }

        @Override
        public void stop(String jobId, boolean forced) {
            try {
                this.delegate.stop(jobId, forced);
            }
            finally {
                this.statusMap.remove(jobId);
            }
        }

        @Override
        public void stop(boolean forced) {
            try {
                this.delegate.stop(forced);
            }
            finally {
                this.statusMap.clear();
            }
        }
    }
}

