/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.postprocessor;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.MutationResponse;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.validation.PostMutationContext;
import com.ontotext.graphql.responder.validation.PostMutationFinalizer;
import com.ontotext.graphql.responder.validation.PostMutationProcessor;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.SparqlRequest;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ClearChangedGraphs
implements PostMutationProcessor,
PostMutationFinalizer {
    private static final String CLEAR_GRAPHS = "clear_graphs";

    public OperationResponse process(EndpointExecutionResponse<MutationResponse> mutationResponse, UpdateExecution request, SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker, PostMutationContext context) {
        if (!mutationResponse.isValid() || mutationResponse.rollback()) {
            return OperationResponse.EMPTY;
        }
        List<String> graphs = request.getOperation().getChanges().stream().map(Change::getTransactionId).map(txId -> "http://www.ontotext.com/changes/" + txId + "/ng").collect(Collectors.toList());
        if (graphs.isEmpty()) {
            return OperationResponse.EMPTY;
        }
        Map clearGraphs = context.getOrCreateMap(CLEAR_GRAPHS);
        clearGraphs.computeIfAbsent(endpoint.toString(), key -> new RemoveNamedGraphs(endpoint, request.getConnectionReusePolicy())).addGraphs(graphs);
        return OperationResponse.EMPTY;
    }

    public void finalizeProcessing(SparqlQueryInvoker sparqlInvoker, PostMutationContext context) {
        if (!context.containsKey((Object)CLEAR_GRAPHS)) {
            return;
        }
        Map clearGraphs = context.getOrCreateMap(CLEAR_GRAPHS);
        for (RemoveNamedGraphs perEndpoint : clearGraphs.values()) {
            perEndpoint.call(sparqlInvoker);
        }
        context.remove((Object)CLEAR_GRAPHS);
    }

    private static class RemoveNamedGraphs
    implements SparqlRequest<Void> {
        private final List<String> graphs = new LinkedList<String>();
        private final String requestId;
        private final SparqlEndpoint endpoint;
        private final ConnectionReusePolicy policy;

        RemoveNamedGraphs(SparqlEndpoint endpoint, ConnectionReusePolicy policy) {
            this.endpoint = endpoint;
            this.policy = policy;
            this.requestId = UUID.randomUUID().toString();
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Void getQuery() {
            return null;
        }

        void addGraphs(Collection<String> ids) {
            this.graphs.addAll(ids);
        }

        void call(SparqlQueryInvoker invoker) {
            invoker.invoke((SparqlRequest)this, this.endpoint, this.policy);
        }

        public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
            Logger logger = Loggers.sparqlQueryLogger();
            if (logger.isTraceEnabled()) {
                logger.trace("Drop graphs: {}", this.graphs);
            }
            connection.dropGraphs(this.graphs);
            return (E)ExecutionResponse.of(null, (String)this.requestId);
        }
    }
}

