/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.postprocessor;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.MutationResponse;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.functions.StorePresenceQueryInvoker;
import com.ontotext.graphql.responder.validation.PostMutationContext;
import com.ontotext.graphql.responder.validation.PostMutationProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.exceptions.QueryEvaluationException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class AffectedObjectCalculator
implements PostMutationProcessor {
    public static final String SO_TYPE = "http://www.ontotext.com/semantic-object/type";

    public OperationResponse process(EndpointExecutionResponse<MutationResponse> mutationResponse, UpdateExecution request, SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker, PostMutationContext mutationContext) {
        Function<List<String>, Map<String, String>> typeResolver = this.resolveTypes(request, (Endpoint)endpoint, sparqlInvoker);
        TransformContext context = AffectedObjectCalculator.convertToMutationResponse(request, mutationResponse, typeResolver);
        OperationResponse response = new OperationResponse();
        context.getErrors().forEach(arg_0 -> ((OperationResponse)response).addErrorMessage(arg_0));
        context.getWarnings().forEach(arg_0 -> ((OperationResponse)response).addWarningMessage(arg_0));
        return response;
    }

    private static TransformContext convertToMutationResponse(UpdateExecution request, EndpointExecutionResponse<MutationResponse> response, Function<List<String>, Map<String, String>> typeResolver) {
        MutationResponse responseData = (MutationResponse)response.getData();
        RdfTree rdfTree = responseData.getQueryData();
        int order = response.getRequest().getIndex();
        if (!response.isValid() || response.rollback()) {
            AffectedObjectCalculator.fillEmptyResponse(request, rdfTree);
            return new TransformContext((Operation)request.getOperation(), rdfTree, response.getExtensions(), order);
        }
        if (AffectedObjectCalculator.shouldFetchChanges(request) && AffectedObjectCalculator.hasAnyResultDiff(responseData)) {
            AffectedObjectCalculator.computeAffectedObjectsBasedOnActualDiff(request, responseData, typeResolver);
        } else {
            AffectedObjectCalculator.ensureCorrectMutationResponse(request, rdfTree);
        }
        return new TransformContext((Operation)request.getOperation(), rdfTree, response.getExtensions(), order);
    }

    private static void fillEmptyResponse(UpdateExecution request, RdfTree rdfTree) {
        Mutation operation = request.getOperation();
        RdfPath rootResult = AffectedObjectCalculator.getRootResult(operation.getResponseName(), rdfTree);
        AffectedObjectCalculator.computeAffectedProps(request, request.getSchema().getPrefixes(), rdfTree, rootResult, StringManipulation.toGraphQlModelName((String)operation.getResponseType()), Collections.emptyList());
    }

    private static RdfPath getRootResult(String responseName, RdfTree rdfTree) {
        return rdfTree.getPool().toPath("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + responseName, (Object)responseName);
    }

    private static void ensureCorrectMutationResponse(UpdateExecution request, RdfTree rdfTree) {
        Mutation operation = request.getOperation();
        Prefixes prefixes = request.getSchema().getPrefixes();
        String responseName = operation.getResponseName();
        RdfPath rootResult = AffectedObjectCalculator.getRootResult(responseName, rdfTree);
        AffectedObjectCalculator.modifyAffectedRdfTree(prefixes, rdfTree, rootResult, request.getOperation(), Collections.emptyMap(), Collections.emptyMap());
    }

    private static boolean hasAnyResultDiff(MutationResponse response) {
        return response.getResultDiff() != null && (response.getResultDiff().getAdded() != null || response.getResultDiff().getRemoved() != null);
    }

    private static void computeAffectedObjectsBasedOnActualDiff(UpdateExecution request, MutationResponse responseData, Function<List<String>, Map<String, String>> typeResolver) {
        Mutation operation = request.getOperation();
        Prefixes prefixes = request.getSchema().getPrefixes();
        RdfTree rdfTree = responseData.getQueryData();
        String responseName = operation.getResponseName();
        Set<String> allModified = AffectedObjectCalculator.computeModifiedEntities(responseData);
        RdfPath rootResult = AffectedObjectCalculator.getRootResult(responseName, rdfTree);
        Map<String, List<String>> typedAffectedMap = AffectedObjectCalculator.associateModifiedIdsWithTypes(request, rdfTree, allModified);
        if (typedAffectedMap.isEmpty()) {
            AffectedObjectCalculator.computeAffectedProps(request, prefixes, rdfTree, rootResult, StringManipulation.toGraphQlModelName((String)operation.getResponseType()), Collections.emptyList());
            return;
        }
        AffectedObjectCalculator.resolveUnknownTypes(typedAffectedMap, typeResolver);
        for (Map.Entry<String, List<String>> typedAffected : typedAffectedMap.entrySet()) {
            List<String> objects = typedAffected.getValue();
            AffectedObjectCalculator.computeAffectedProps(request, prefixes, rdfTree, rootResult, typedAffected.getKey(), objects);
        }
    }

    private static void resolveUnknownTypes(Map<String, List<String>> typedAffectedMap, Function<List<String>, Map<String, String>> typeResolver) {
        List<String> unknownTypes = typedAffectedMap.remove("Object");
        if (unknownTypes == null || unknownTypes.isEmpty()) {
            return;
        }
        Map<String, String> resolved = typeResolver.apply(unknownTypes);
        for (String id : unknownTypes) {
            String type = resolved.getOrDefault(id, "Object");
            typedAffectedMap.computeIfAbsent(type, key -> new ArrayList()).add(id);
        }
    }

    private Function<List<String>, Map<String, String>> resolveTypes(UpdateExecution request, Endpoint endpoint, SparqlQueryInvoker sparqlInvoker) {
        SomlSchema schema = request.getSchema();
        OperationBuilderOptions options = request.getOperationOptions();
        ValidatorOptions validatorOptions = request.getValidatorOptions();
        StorePresenceQueryInvoker invoker = new StorePresenceQueryInvoker(endpoint, sparqlInvoker);
        return ids -> {
            RdfTree rdfTree;
            try {
                rdfTree = invoker.executeObjectQuery(schema, (Collection)ids, true, options);
            }
            catch (QueryEvaluationException qee) {
                if (validatorOptions.getValidationFailureMode() != ValidatorOptions.ValidationFailureMode.FAIL) {
                    rdfTree = EntityPoolFactory.defaultPool().emptyTree();
                    Loggers.graphqlLogger().warn("Could not query affected object types due to store error", (Throwable)qee);
                }
                throw qee;
            }
            ValueReader valueReader = rdfTree.getValueReader();
            HashMap<String, String> result = new HashMap<String, String>();
            for (String id : ids) {
                Collection triples = rdfTree.findAtAnyDepth(id, SO_TYPE, null);
                if (triples.isEmpty()) continue;
                String type = valueReader.read(((Triple)triples.iterator().next()).getObject()).toString();
                result.put(id, schema.getObjects().resolveByType(type, Shape::asGraphQl));
            }
            return result;
        };
    }

    private static void computeAffectedProps(UpdateExecution request, Prefixes prefixes, RdfTree rdfTree, RdfPath rootResult, String type, List<String> objects) {
        HashMap<String, Object> countMap = new HashMap<String, Object>();
        countMap.put("kind", type);
        countMap.put("count", objects.size());
        countMap.put("__typename", "AffectedCount");
        HashMap<String, Object> objectsMap = new HashMap<String, Object>();
        objectsMap.put("kind", type);
        objectsMap.put("ids", objects);
        objectsMap.put("__typename", "AffectedObjects");
        AffectedObjectCalculator.modifyAffectedRdfTree(prefixes, rdfTree, rootResult, request.getOperation(), countMap, objectsMap);
    }

    private static void modifyAffectedRdfTree(Prefixes prefixes, RdfTree rdfTree, RdfPath rootResult, Mutation operation, Map<String, Object> countMap, Map<String, Object> objectsMap) {
        EntityPool pool = rdfTree.getPool();
        long modifiedTypePredicate = pool.resolve((Object)AffectedObjectCalculator.nameToIri(prefixes, AffectedObjectCalculator.normalizeReturnType(operation.getResponseType())));
        rdfTree.selectPaths(pool.toPath("http://www.ontotext.com/semantic-object/result/", null, null)).stream().filter(triple -> triple.getObject() != rootResult.getObject()).forEach(rdfPath -> AffectedObjectCalculator.changeTreeForObject(rdfTree, rootResult, modifiedTypePredicate, rdfPath.getObject()));
        if (!countMap.isEmpty()) {
            rdfTree.add(rootResult, AffectedObjectCalculator.nameToIri(prefixes, "affected_count"), countMap);
        }
        if (!objectsMap.isEmpty()) {
            rdfTree.add(rootResult, AffectedObjectCalculator.nameToIri(prefixes, "affected_objects"), objectsMap);
        }
        rdfTree.add(rootResult, SO_TYPE, (Object)operation.getReturnType());
    }

    private static void changeTreeForObject(RdfTree rdfTree, RdfPath rootResult, long modifiedTypePredicate, long affectedObject) {
        rdfTree.moveTo(rootResult.add(modifiedTypePredicate, affectedObject));
    }

    private static Map<String, List<String>> associateModifiedIdsWithTypes(UpdateExecution request, RdfTree rdfTree, Set<String> allModified) {
        LinkedHashMap<String, List<String>> typedAllModified = new LinkedHashMap<String, List<String>>();
        ValueReader reader = rdfTree.getValueReader();
        SomlSchema schema = request.getSchema();
        for (String affectedObject : allModified) {
            String type = rdfTree.findAtAnyDepth(affectedObject, SO_TYPE, null).stream().map(triple -> reader.read(triple.getObject()).toString()).map(typeValue -> schema.getObjects().resolveByType(typeValue, Shape::asGraphQl)).findFirst().orElseGet(() -> AffectedObjectCalculator.getTypeFromRequestChanges(request, affectedObject));
            if (type == null) continue;
            typedAllModified.computeIfAbsent(type, objects -> new ArrayList()).add(affectedObject);
        }
        return typedAllModified;
    }

    private static String getTypeFromRequestChanges(UpdateExecution request, String affectedObject) {
        Optional<Change> match = request.getOperation().getChanges().stream().filter(AffectedObjectCalculator.matchEntityId(affectedObject)).findFirst();
        Optional entityId = match.flatMap(Change::getEntityId);
        Optional newEntityId = match.flatMap(Change::getNewEntityId);
        if (newEntityId.isPresent() && entityId.filter(Predicate.isEqual(affectedObject)).isPresent() && !entityId.equals(newEntityId)) {
            return null;
        }
        return match.map(change -> change.getShape().getId()).orElse("Object");
    }

    private static Predicate<Change> matchEntityId(String affectedObject) {
        return change -> {
            Optional newEntityId = change.getNewEntityId();
            boolean matched = false;
            if (newEntityId.isPresent()) {
                matched = newEntityId.filter(Predicate.isEqual(affectedObject)).isPresent();
            }
            if (!matched) {
                matched = change.getEntityId().filter(Predicate.isEqual(affectedObject)).isPresent();
            }
            return matched;
        };
    }

    private static Set<String> computeModifiedEntities(MutationResponse responseData) {
        RdfTree added = responseData.getResultDiff().getAdded();
        RdfTree removed = responseData.getResultDiff().getRemoved();
        Collection<Object> addedSubjects = Collections.emptyList();
        if (added != null) {
            addedSubjects = added.getResultIris("added");
        }
        Collection<Object> removedSubjects = Collections.emptyList();
        if (removed != null) {
            removedSubjects = removed.getResultIris("removed");
        }
        HashSet<String> allModified = new HashSet<String>();
        for (String string : addedSubjects) {
            if (string.startsWith("http://www.ontotext.com/changes/")) continue;
            allModified.add(string);
        }
        allModified.addAll(removedSubjects);
        return allModified;
    }

    private static String nameToIri(Prefixes prefixes, String name) {
        return prefixes.toIri(prefixes.nameToShortIri(name));
    }

    private static String normalizeReturnType(String returnType) {
        String escapedType = StringManipulation.replaceColonWithUnderscore((String)returnType);
        return StringUtils.uncapitalize((String)escapedType);
    }

    private static boolean shouldFetchChanges(UpdateExecution execution) {
        return execution.needToFetchChanges();
    }
}

