/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.dynamicvalidator;

import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.functions.SimpleQueryInvoker;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidator;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidatorCallback;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.Query;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.validator.mutation.SoTypeValidator;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=30)
public class SoTypeUpdateValidator
implements AsyncMutationActiveValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static SoTypeCollectQueryBuilder qBuilder = new SoTypeCollectQueryBuilder();
    private SoTypeValidator soTypeValidator = new SoTypeValidator();

    public MutationActiveValidator.Phase getPhase() {
        return MutationActiveValidator.Phase.PRE_TX;
    }

    public AsyncMutationActiveValidatorCallback createAsyncValidator(final UpdateExecution request, final MutationActiveValidator.ActiveValidationContext context) {
        if (!(request.getOperation() instanceof UpdateMutation) || request.getOperation().getChanges().isEmpty()) {
            return null;
        }
        SomlSchema schema = request.getSchema();
        final Map<Shape, Set<String>> idsToCheck = this.collectIdsToCheck(request, schema);
        if (idsToCheck.isEmpty()) {
            return null;
        }
        if (!request.isSilent()) {
            long idCount = idsToCheck.values().stream().mapToInt(Set::size).count();
            String ids = idsToCheck.values().stream().flatMap(Collection::stream).collect(Collectors.joining(", ", "[", "]"));
            LOGGER.info("Checking {} entities for valid types after update: {}", (Object)idCount, (Object)ids);
        }
        idsToCheck.values().removeIf(Set::isEmpty);
        if (idsToCheck.isEmpty()) {
            return null;
        }
        return new AsyncMutationActiveValidatorCallback(){
            private OperationResponse response = new OperationResponse();

            public void invokeAsync() {
                SimpleQueryInvoker simpleQuery = new SimpleQueryInvoker(() -> ((MutationActiveValidator.ActiveValidationContext)context).getEndpoint(), context.getSparqlInvoker());
                for (Map.Entry entry : idsToCheck.entrySet()) {
                    SoTypeUpdateValidator.this.validateSingleType((Shape)entry.getKey(), (Set)entry.getValue(), request, simpleQuery, this.response);
                }
            }

            public OperationResponse completeValidation() {
                return this.response;
            }

            public MutationActiveValidator getValidator() {
                return SoTypeUpdateValidator.this;
            }
        };
    }

    private void validateSingleType(Shape shape, Set<String> idsToCheck, UpdateExecution request, SimpleQueryInvoker simpleQuery, OperationResponse resp) {
        HashMap<String, String> iriTypeMap = new HashMap<String, String>();
        shape.getAllProperties().forEach(SoTypeUpdateValidator.collectIriType(shape, iriTypeMap));
        Query query = qBuilder.getQuery(shape, iriTypeMap, idsToCheck);
        RdfTree data = simpleQuery.query(query, true, request.getOperationOptions()).map(TransformContext::getDataOrFail).orElse(null);
        if (data == null) {
            return;
        }
        HashMap<String, Map<String, Set<String>>> descrMap = new HashMap<String, Map<String, Set<String>>>();
        SomlSchema schema = request.getSchema();
        for (Triple triple : data.getAllTriples()) {
            if (!idsToCheck.contains(triple.getSubject())) continue;
            descrMap.computeIfAbsent(triple.getSubject(), k -> new HashMap()).computeIfAbsent(schema.getPrefixes().toShortIri(triple.getPredicate()), k -> new HashSet()).add(String.valueOf(triple.getObject()));
        }
        for (Change change : request.getOperation().getChanges()) {
            Optional entityId = change.getEntityId();
            if (entityId.filter(idsToCheck::contains).isPresent()) {
                this.callSoTypeValidator((String)entityId.get(), change, resp, descrMap);
                continue;
            }
            this.validateExpressionIds(descrMap, resp, change, idsToCheck);
        }
    }

    private static BiConsumer<String, PropertyShape> collectIriType(Shape shape, Map<String, String> iriTypeMap) {
        return (propId, propShape) -> {
            Optional property = shape.getProperty(propShape.getName());
            property.ifPresent(prop -> iriTypeMap.putIfAbsent(prop.getRdfProperty(), (String)propId));
        };
    }

    private Map<Shape, Set<String>> collectIdsToCheck(UpdateExecution request, SomlSchema schema) {
        HashMap<Shape, Set<String>> idsToCheck = new HashMap<Shape, Set<String>>();
        for (Change change : request.getOperation().getChanges()) {
            if (!this.soTypeValidator.changeAffectsDescriptors(schema, change)) continue;
            Shape shape = change.getShape();
            change.getEntityId().ifPresent(id -> idsToCheck.computeIfAbsent(shape, key -> new HashSet()).add(id));
            if (!change.hasPreconditions()) continue;
            for (String id2 : change.getPreconditions().getIdSelection()) {
                idsToCheck.computeIfAbsent(shape, key -> new HashSet()).add(id2);
            }
        }
        return idsToCheck;
    }

    private void validateExpressionIds(Map<String, Map<String, Set<String>>> descrMap, OperationResponse resp, Change change, Set<String> idsToCheck) {
        if (change.hasPreconditions() && !change.getPreconditions().getIdSelection().isEmpty()) {
            for (String id : change.getPreconditions().getIdSelection()) {
                if (!idsToCheck.contains(id)) continue;
                this.callSoTypeValidator(id, change, resp, descrMap);
            }
        }
    }

    private void callSoTypeValidator(String id, Change change, OperationResponse resp, Map<String, Map<String, Set<String>>> descrMap) {
        Map changeDescMap = descrMap.computeIfAbsent(id, key -> new HashMap());
        this.soTypeValidator.validateCreateChange(change, changeDescMap, arg_0 -> ((OperationResponse)resp).add(arg_0));
    }

    public static class SoTypeCollectQueryBuilder {
        private static final ValueFactory vf = SimpleValueFactory.getInstance();

        protected Query getQuery(Shape shape, Map<String, String> iriTypeMap, Collection<String> ids) {
            Query query = new Query();
            String typeName = shape.asGraphQl();
            query.setName(StringUtils.uncapitalize((String)typeName));
            query.setReturnType(typeName);
            query.setReturnTypeInstance(shape);
            Arguments args = new Arguments();
            args.setWhere((ExpressionValue)ExpressionsFactory.term((String)"IN", ids.stream().map(arg_0 -> ((ValueFactory)vf).createIRI(arg_0)).collect(Collectors.toList())));
            query.setArguments(args);
            query.setSelections(new LinkedList());
            shape.getContainedIn().forEach((shId, sh) -> {
                if (sh.getType() == null) {
                    return;
                }
                if (!iriTypeMap.containsKey(sh.getTypePropIri())) {
                    return;
                }
                String prop = (String)iriTypeMap.get(sh.getTypePropIri());
                if (query.getSelections().stream().anyMatch(sel -> sel.getName().equals(prop))) {
                    return;
                }
                Selection sel2 = new Selection();
                sel2.setName(StringManipulation.toGraphQlModelName((String)prop));
                sel2.setDefinedIn(typeName);
                sel2.setDefinedInType(shape);
                sel2.setSelections(new LinkedList());
                sel2.setRequestedByUser(false);
                sel2.setCollection(true);
                sel2.setArguments(new Arguments());
                sel2.setParent((Selectable)query);
                query.getSelections().add(sel2);
            });
            return query;
        }
    }
}

