/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.dynamicvalidator;

import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidator;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidatorCallback;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.soaas.common.rdf.ValueReader;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=20)
public class ReferencedObjectsTypeValidator
implements AsyncMutationActiveValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public MutationActiveValidator.Phase getPhase() {
        return MutationActiveValidator.Phase.PRE_TX;
    }

    public AsyncMutationActiveValidatorCallback createAsyncValidator(final UpdateExecution request, final MutationActiveValidator.ActiveValidationContext context) {
        final List<ValidationInfo> validationInfo = this.toValidationInfo(request.getOperation().getChanges(), request.getSchema());
        final HashSet ids = new HashSet();
        validationInfo.forEach(info -> ids.addAll(info.getReferences()));
        return new AsyncMutationActiveValidatorCallback(){
            private Map<String, List<String>> storeResult;

            public void invokeAsync() {
                if (!ids.isEmpty()) {
                    if (!request.isSilent()) {
                        LOGGER.info("Checking {} entities for reference type correctness: {}", (Object)ids.size(), (Object)ids);
                    }
                    this.storeResult = ReferencedObjectsTypeValidator.this.validateAgainstStoreData(context, ids, request.getOperationOptions());
                }
            }

            public OperationResponse completeValidation() {
                if (this.storeResult != null) {
                    context.getTrackedObjects().forEach((id, data) -> this.storeResult.computeIfAbsent((String)id, key -> new ArrayList()).add(data.getShapeId()));
                }
                SomlSchema schema = context.getSoml();
                for (ValidationInfo info1 : validationInfo) {
                    ReferencedObjectsTypeValidator.this.validateInfo(info1, this.storeResult, schema);
                }
                OperationResponse response = new OperationResponse();
                validationInfo.stream().filter(info -> !info.getInvalidReferences().isEmpty()).forEach(ReferencedObjectsTypeValidator.this.reportErrors(response));
                return response;
            }

            public MutationActiveValidator getValidator() {
                return ReferencedObjectsTypeValidator.this;
            }
        };
    }

    private List<ValidationInfo> toValidationInfo(List<Change> changes, SomlSchema schema) {
        return changes.stream().flatMap(change -> change.getChanges().stream().map(this.buildValidationInfo(schema, (Change)change, changes))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Function<PropertyChange, ValidationInfo> buildValidationInfo(SomlSchema schema, Change change, List<Change> currentChanges) {
        return propChange -> {
            Optional<Shape> range = this.getPropertyRangeShape(schema, change.getShape(), (PropertyChange)propChange);
            if (!range.isPresent()) {
                return null;
            }
            HashSet<String> invalidReferences = new HashSet<String>();
            Set<String> references = this.getReferencedIds((PropertyChange)propChange);
            this.filterAndValidatePresent(currentChanges, references, range.get(), invalidReferences);
            return new ValidationInfo(change, propChange.getName(), range.get(), references, invalidReferences);
        };
    }

    private Optional<Shape> getPropertyRangeShape(SomlSchema schema, Shape shape, PropertyChange propChange) {
        return shape.getProperty(schema.getPrefixes().nameToShortIri(propChange.getName())).map(PropertyShape::getRange).map(arg_0 -> schema.getObjects().get(arg_0));
    }

    private Set<String> getReferencedIds(PropertyChange propChange) {
        return propChange.getValueAsCollection().stream().filter(Objects::nonNull).map(String::valueOf).filter(ReferenceId::isNotReferenceId).collect(Collectors.toSet());
    }

    private void filterAndValidatePresent(List<Change> currentChanges, Set<String> referencedIds, Shape rangeShape, Set<String> invalidReferences) {
        LinkedList<Change> currentChangesCopy = new LinkedList<Change>(currentChanges);
        currentChangesCopy.removeIf(change -> !change.getEntityId().filter(referencedIds::contains).isPresent());
        Set idsToCheck = currentChangesCopy.stream().map(change -> change.getEntityId().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
        referencedIds.removeAll(idsToCheck);
        currentChangesCopy.stream().filter(this.doesNotMatchType(rangeShape)).forEach(change -> change.getEntityId().ifPresent(invalidReferences::add));
    }

    private Predicate<Change> doesNotMatchType(Shape rangeShape) {
        Collection rangeSubTypes = rangeShape.getConcreteSubTypes();
        return change -> !rangeShape.equals((Object)change.getShape()) && !rangeSubTypes.contains(change.getShape());
    }

    private Map<String, List<String>> validateAgainstStoreData(MutationActiveValidator.ActiveValidationContext context, Set<String> ids, OperationBuilderOptions options) {
        SomlSchema schema = context.getSoml();
        RdfTree rdfTree = context.getStoreInvoker().executeObjectQuery(schema, ids, true, options);
        return rdfTree.getAllTriples().stream().filter(triple -> !"http://www.ontotext.com/semantic-object/result/".equals(triple.getSubject())).collect(this.collectTypes(rdfTree.getValueReader(), schema));
    }

    private Collector<Triple, ?, Map<String, List<String>>> collectTypes(ValueReader valueReader, SomlSchema schema) {
        return Collectors.groupingBy(Triple::getSubject, Collectors.mapping(triple -> this.readModelId(schema, valueReader.read(triple.getObject())), Collectors.toList()));
    }

    private String readModelId(SomlSchema schema, Object typeValue) {
        String type = Objects.toString(typeValue);
        Shape shape = schema.getObjects().getByType(type);
        if (shape != null) {
            return shape.getId();
        }
        return schema.getPrefixes().toModelShortIri(type);
    }

    private void validateInfo(ValidationInfo info, Map<String, List<String>> storeResult, SomlSchema schema) {
        String rangeId = info.getPropertyRange().getId();
        Collection rangeSubTypes = schema.getObjects().getIfPresent(rangeId).map(Shape::getConcreteSubTypes).orElse(List.of());
        info.getReferences().forEach(reference -> {
            if (!storeResult.containsKey(reference) || !this.isRangeCompliant((List)storeResult.get(reference), rangeId, rangeSubTypes, schema)) {
                info.getInvalidReferences().add((String)reference);
            }
        });
    }

    private boolean isRangeCompliant(List<String> typesToCheck, String rangeType, Collection<Shape> rangeSubTypes, SomlSchema schema) {
        if (typesToCheck == null || typesToCheck.isEmpty()) {
            return false;
        }
        return typesToCheck.contains(rangeType) || this.isMatchingAnyRangeSubtypes(typesToCheck, rangeSubTypes, schema);
    }

    private boolean isMatchingAnyRangeSubtypes(List<String> typesToCheck, Collection<Shape> rangeSubTypes, SomlSchema schema) {
        return typesToCheck.stream().map(arg_0 -> schema.getObjects().get(arg_0)).filter(Objects::nonNull).anyMatch(rangeSubTypes::contains);
    }

    private Consumer<ValidationInfo> reportErrors(OperationResponse response) {
        return info -> {
            Change change = info.getChange();
            response.add((OperationResponse.OperationMessage)QueryValidationMessage.error((SourceLocation)change.getSourceLocation(), (String)"mutation.invalid.property.reference", (Object[])new Object[]{info.getInvalidReferences(), info.getPropertyRange().getId(), change.getShape().getId() + "." + info.getPropertyName()}));
        };
    }

    private static class ValidationInfo {
        private Change change;
        private String propertyName;
        private Shape propertyRange;
        private Collection<String> references;
        private Collection<String> invalidReferences;

        private ValidationInfo(Change change, String propertyName, Shape propertyRange, Collection<String> references, Collection<String> invalidReferences) {
            this.change = change;
            this.propertyName = propertyName;
            this.propertyRange = propertyRange;
            this.references = references;
            this.invalidReferences = invalidReferences;
        }

        Change getChange() {
            return this.change;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        Shape getPropertyRange() {
            return this.propertyRange;
        }

        Collection<String> getReferences() {
            return this.references;
        }

        Collection<String> getInvalidReferences() {
            return this.invalidReferences;
        }
    }
}

