/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.dynamicvalidator;

import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidator;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidatorCallback;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.OperationType;
import com.ontotext.models.Shape;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=10)
public class IdExistenceValidator
implements AsyncMutationActiveValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ID = "id";

    public MutationActiveValidator.Phase getPhase() {
        return MutationActiveValidator.Phase.PRE_TX;
    }

    public AsyncMutationActiveValidatorCallback createAsyncValidator(final UpdateExecution update, final MutationActiveValidator.ActiveValidationContext context) {
        OperationType operation = update.getOperation().getOperationType();
        if (OperationType.DELETE.equals((Object)operation)) {
            return null;
        }
        final LinkedHashMap<String, Pair> createIds = new LinkedHashMap<String, Pair>();
        for (Change change : update.getOperation().getChanges()) {
            if (OperationType.CREATE.equals((Object)change.getType())) {
                createIds.put(change.getId(), Pair.of((Object)change.getSourceLocation(), (Object)change.getShape()));
                continue;
            }
            if (!OperationType.UPDATE.equals((Object)change.getType())) continue;
            this.getIdPropertyChange(change).ifPresent(propChange -> {
                String idValue = (String)propChange.getRawValue();
                createIds.put(idValue, Pair.of((Object)change.getSourceLocation(), (Object)change.getShape()));
            });
        }
        if (createIds.isEmpty()) {
            return null;
        }
        return new AsyncMutationActiveValidatorCallback(){
            private RdfTree storeResult;

            public void invokeAsync() {
                this.storeResult = IdExistenceValidator.this.performStoreSearch(context, createIds, update.isSilent(), update.getOperationOptions());
            }

            public OperationResponse completeValidation() {
                if (this.storeResult == null) {
                    return OperationResponse.createFailed();
                }
                Map trackedObjects = context.getTrackedObjects();
                OperationResponse response = new OperationResponse();
                createIds.forEach((id, info) -> {
                    if (IdExistenceValidator.this.alreadyPresent(this.storeResult, (String)id, trackedObjects.keySet())) {
                        SourceLocation location = (SourceLocation)info.getLeft();
                        IdExistenceValidator.this.reportError(response, (String)id, location);
                    }
                    Shape shape = (Shape)info.getRight();
                    trackedObjects.computeIfAbsent(id, MutationActiveValidator.ActiveValidationContext.ObjectData::create).setShapeId(shape.getId());
                });
                return response;
            }

            public MutationActiveValidator getValidator() {
                return IdExistenceValidator.this;
            }
        };
    }

    private Optional<PropertyChange> getIdPropertyChange(Change createChange) {
        return createChange.getChanges().stream().filter(propChange -> ID.equals(propChange.getName())).findFirst();
    }

    private RdfTree performStoreSearch(MutationActiveValidator.ActiveValidationContext context, Map<String, Pair<SourceLocation, Shape>> createIds, boolean silent, OperationBuilderOptions operationOptions) {
        if (!silent) {
            LOGGER.info("Checking {} entities for existence: {}", (Object)createIds.size(), createIds.keySet());
        }
        return context.getStoreInvoker().executeObjectQuery(context.getSoml(), createIds.keySet(), true, operationOptions);
    }

    private boolean alreadyPresent(RdfTree storeSearchResult, String id, Set<String> createdInPreviousUpdate) {
        return createdInPreviousUpdate.contains(id) || !storeSearchResult.findAtAnyDepth(id, null, null).isEmpty();
    }

    private void reportError(OperationResponse response, String duplicate, SourceLocation location) {
        response.add((OperationResponse.OperationMessage)QueryValidationMessage.error((SourceLocation)location, (String)"mutation.id.create.duplicate", (Object[])new Object[]{duplicate}));
    }
}

