/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.schema.preprocess;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.extensions.SchemaExtension;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

@Order(value=1100)
public class SetExpressionPrefixResolver
implements SchemaExtension {
    public void process(SomlSchema somlSchema) {
        somlSchema.getObjects().values().forEach(shape -> SetExpressionPrefixResolver.resolveExpressionPrefix(shape, somlSchema.getPrefixes().values()));
    }

    private static void resolveExpressionPrefix(Shape shape, Collection<String> knownPrefixes) {
        if (StringUtils.isNotBlank((CharSequence)shape.getPattern())) {
            SetExpressionPrefixResolver.setPrefixResolvingFun(() -> ((Shape)shape).getPattern(), arg_0 -> ((Shape)shape).setPattern(arg_0), knownPrefixes);
        }
        shape.getProps().values().stream().filter(prop -> StringUtils.isNotBlank((CharSequence)prop.getGen())).forEach(prop -> SetExpressionPrefixResolver.setPrefixResolvingFun(() -> ((PropertyShape)prop).getGen(), arg_0 -> ((PropertyShape)prop).setGen(arg_0), knownPrefixes));
    }

    private static void setPrefixResolvingFun(Supplier<String> getter, Consumer<String> setter, Collection<String> knownPrefixes) {
        String[] prefixAndValue = getter.get().split(":", 2);
        if (prefixAndValue.length == 2 && knownPrefixes.contains(prefixAndValue[0])) {
            setter.accept("${resolvePrefix('" + prefixAndValue[0] + "')}" + prefixAndValue[1]);
        }
    }
}

