/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.script.model.DefaultJsValueConverter;
import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.JsValueConverter;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.List;

public class JsValueFactory {
    private static final JsValueFactory INSTANCE = new JsValueFactory();
    private List<JsValueConverter> converters;

    private JsValueFactory() {
    }

    public static JsValueFactory instance() {
        return INSTANCE;
    }

    JsValue ofTypeAndValue(String name, String type, Object value) {
        if (value instanceof JsValue) {
            return (JsValue)value;
        }
        Object convertedValue = this.resolveExtension(type, value).convertValue(name, type, value);
        if (convertedValue instanceof JsValue) {
            return (JsValue)convertedValue;
        }
        return DefaultJsValueConverter.DEFAULT_JS_VALUE_CONVERTER.convertValue(name, type, convertedValue);
    }

    JsValue ofExpression(String name, String type, String expression) {
        return DefaultJsValueConverter.DEFAULT_JS_VALUE_CONVERTER.createExpression(name, type, expression);
    }

    private JsValueConverter resolveExtension(String type, Object value) {
        for (JsValueConverter extension : this.getConverters()) {
            if (!extension.accept(type, value)) continue;
            return extension;
        }
        return DefaultJsValueConverter.DEFAULT_JS_VALUE_CONVERTER;
    }

    private List<JsValueConverter> getConverters() {
        if (this.converters == null) {
            this.converters = PluginsManager.loadPlugins(JsValueConverter.class);
        }
        return this.converters;
    }
}

