/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.script.model.JsValueFactory;
import com.ontotext.script.model.ValueResolver;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Objects;
import java.util.function.BiFunction;

public class JsValue<V> {
    public static final String ESCAPE_CHAR = "-";
    private final String name;
    private V value;
    private ValueResolver<V> valueResolver;
    private String escapeChar;

    protected JsValue(String name, V value) {
        this.name = name;
        this.value = value;
    }

    protected JsValue(String name, ValueResolver<V> valueResolver) {
        this.name = name;
        this.valueResolver = valueResolver;
    }

    public static JsValue of(Object value) {
        return JsValueFactory.instance().ofTypeAndValue(null, null, value);
    }

    public static JsValue ofValue(String name, Object value) {
        return JsValueFactory.instance().ofTypeAndValue(name, null, value);
    }

    public static JsValue ofValue(String name, String type, Object value) {
        return JsValueFactory.instance().ofTypeAndValue(name, type, value);
    }

    public static JsValue ofType(String name, String type) {
        return JsValueFactory.instance().ofTypeAndValue(name, type, null);
    }

    public static JsValue ofExpression(String name, String type, String expression) {
        return JsValueFactory.instance().ofExpression(name, type, expression);
    }

    public V get() {
        if (this.isEmpty() && this.isLazy()) {
            this.value = this.getValueResolver().getValue();
        }
        return this.value;
    }

    public JsValue escape() {
        if (this.escapeChar == null) {
            this.escapeChar = ESCAPE_CHAR;
        }
        return this;
    }

    public JsValue escape(String replaceWith) {
        this.escapeChar = replaceWith;
        return this;
    }

    protected void setValue(V value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNumber() {
        return this.get() instanceof Number;
    }

    public boolean isBoolean() {
        return this.get() instanceof Boolean;
    }

    public boolean isString() {
        return this.get() instanceof String;
    }

    public boolean isTemporal() {
        return this.get() instanceof Date || this.get() instanceof Temporal;
    }

    public boolean isIri() {
        return false;
    }

    public boolean isLazy() {
        return this.valueResolver != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public String toString() {
        String string = this.asString();
        string = this.doEscape(string, this.escapeChar);
        return string;
    }

    public String asString() {
        return Objects.toString(this.get());
    }

    public JsValue copy() {
        return this.copyFactory().apply(this.getName(), this.get());
    }

    protected BiFunction<String, V, JsValue> copyFactory() {
        return JsValue::new;
    }

    protected String doEscape(String val, String escapeChar) {
        if (escapeChar == null) {
            return val;
        }
        String updated = val.replaceAll("^[\\W_]+", "").replaceAll("[\\W_]+$", "");
        return updated.replaceAll("\\W+", escapeChar);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsValue)) {
            return false;
        }
        JsValue value1 = (JsValue)obj;
        return Objects.equals(this.getName(), value1.getName()) && Objects.equals(this.value, value1.value);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.value);
    }

    public ValueResolver<V> getValueResolver() {
        return this.valueResolver;
    }
}

