/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.NameBasedGenerator;
import com.ontotext.script.model.JsBaseTemporalValue;
import com.ontotext.script.model.JsValue;
import java.security.SecureRandom;
import java.util.Date;
import java.util.UUID;

public class JsUtils {
    private static final int NAME_SIZE_IN_BITS = 16;
    private static final NameBasedGenerator UUID_GEN = Generators.nameBasedGenerator((UUID)UUID.randomUUID());
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private JsUtils() {
    }

    public static JsValue uuid() {
        byte[] bytes = new byte[16];
        SECURE_RANDOM.nextBytes(bytes);
        String value = UUID_GEN.generate(bytes).toString();
        return JsValue.of(value);
    }

    public static JsValue now(String pattern) {
        JsValue jsValue = JsValue.of(new Date());
        if (jsValue instanceof JsBaseTemporalValue && pattern != null) {
            JsBaseTemporalValue date = (JsBaseTemporalValue)jsValue;
            date.format(pattern);
        }
        return jsValue;
    }
}

