/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.script.model.JsBaseTemporalValue;
import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.ValueResolver;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.function.BiFunction;

public class JsDateValue
extends JsBaseTemporalValue<Date> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSXXXXX");

    JsDateValue(String name, Date value) {
        super(name, value);
        this.setFormatter(DEFAULT_FORMATTER);
    }

    JsDateValue(String name, ValueResolver<Date> valueResolver) {
        super(name, valueResolver);
    }

    @Override
    public JsDateValue format(String formatPattern) {
        if (formatPattern == null) {
            this.setFormatter(DEFAULT_FORMATTER);
        } else {
            this.setFormatter(DateTimeFormatter.ofPattern(formatPattern));
        }
        return this;
    }

    @Override
    public String asString() {
        if (this.get() == null) {
            return super.asString();
        }
        return OffsetDateTime.ofInstant(((Date)this.get()).toInstant(), ZoneId.systemDefault()).format(this.getFormatter());
    }

    @Override
    protected BiFunction<String, Date, JsValue> copyFactory() {
        return JsDateValue::new;
    }
}

