/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.ValueResolver;
import java.time.format.DateTimeFormatter;

public abstract class JsBaseTemporalValue<T>
extends JsValue<T> {
    private DateTimeFormatter formatter;

    protected JsBaseTemporalValue(String name, T value) {
        super(name, value);
    }

    protected JsBaseTemporalValue(String name, ValueResolver<T> valueResolver) {
        super(name, valueResolver);
    }

    public JsBaseTemporalValue format(String formatPattern) {
        if (formatPattern != null) {
            this.setFormatter(DateTimeFormatter.ofPattern(formatPattern));
        }
        return this;
    }

    protected DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    protected void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    protected String doEscape(String val, String escapeChar) {
        if (escapeChar == null) {
            return val;
        }
        return val.replace(":", escapeChar).replace('+', '_');
    }

    @Override
    public boolean isTemporal() {
        return true;
    }
}

