/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.script.model.IriValueResolver;
import com.ontotext.script.model.JsBooleanValue;
import com.ontotext.script.model.JsDateValue;
import com.ontotext.script.model.JsIriValue;
import com.ontotext.script.model.JsNumberValue;
import com.ontotext.script.model.JsStringValue;
import com.ontotext.script.model.JsTemporalValue;
import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.JsValueConverter;
import com.ontotext.script.model.ValueResolver;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultJsValueConverter
implements JsValueConverter {
    private static final Set<String> NUMBER_TYPES = Stream.of("Byte", "Short", "Int", "Long", "Integer", "PositiveInteger", "NegativeInteger", "NonPositiveInteger", "NonNegativeInteger", "UnsignedByte", "UnsignedInteger", "UnsignedShort", "UnsignedLong", "Float", "Decimal").collect(Collectors.toSet());
    private static final Set<String> TEMPORAL_TYPES = Stream.of("Date", "Time", "DateTime", "Year", "YearMonth").collect(Collectors.toSet());
    static final DefaultJsValueConverter DEFAULT_JS_VALUE_CONVERTER = new DefaultJsValueConverter();

    @Override
    public boolean accept(String type, Object value) {
        return true;
    }

    @Override
    public JsValue convertValue(String name, String type, Object value) {
        if (type == null && value == null) {
            return new JsValue<Object>(name, null);
        }
        if (type == null) {
            return DefaultJsValueConverter.ofValue(name, value);
        }
        return DefaultJsValueConverter.ofType(name, type, value);
    }

    JsValue createExpression(String name, String type, String expression) {
        return DefaultJsValueConverter.ofExpression(name, type, expression);
    }

    private static JsValue ofValue(String name, Object value) {
        if (value instanceof JsValue) {
            return (JsValue)value;
        }
        if (value instanceof Number) {
            return new JsNumberValue(name, (Number)value);
        }
        if (value instanceof Date) {
            return new JsDateValue(name, (Date)value);
        }
        if (value instanceof Temporal) {
            return new JsTemporalValue(name, (Temporal)value);
        }
        if (value instanceof String) {
            return new JsStringValue(name, (String)value);
        }
        if (value instanceof Boolean) {
            return new JsBooleanValue(name, (Boolean)value);
        }
        return new JsValue<Object>(name, value);
    }

    private static JsValue ofType(String name, String type, Object value) {
        if (value instanceof Collection || value instanceof Map) {
            return new JsValue<Object>(name, value);
        }
        if (NUMBER_TYPES.contains(type) && (value == null || value instanceof Number)) {
            return new JsNumberValue(name, (Number)value);
        }
        if (TEMPORAL_TYPES.contains(type)) {
            return DefaultJsValueConverter.toTemporalValue(name, value);
        }
        if ("String".equals(type)) {
            return new JsStringValue(name, Objects.toString(value, null));
        }
        if ("Boolean".equals(type) && (value == null || value instanceof Boolean)) {
            return new JsBooleanValue(name, (Boolean)value);
        }
        if ("ID".equals(type)) {
            return new JsIriValue(name, Objects.toString(value, null));
        }
        return new JsValue<Object>(name, value);
    }

    private static JsValue toTemporalValue(String name, Object value) {
        if (value == null || value instanceof Date) {
            return new JsDateValue(name, (Date)value);
        }
        if (value instanceof Calendar) {
            return new JsDateValue(name, ((Calendar)value).getTime());
        }
        if (value instanceof Temporal) {
            return new JsTemporalValue(name, (Temporal)value);
        }
        return new JsValue<Object>(name, value);
    }

    private static JsValue ofExpression(String name, String type, String expression) {
        ValueResolver resolver = "ID".equals(type) ? new IriValueResolver(name, expression) : new ValueResolver(name, expression);
        if (NUMBER_TYPES.contains(type)) {
            return new JsNumberValue(name, resolver);
        }
        if (TEMPORAL_TYPES.contains(type)) {
            return new JsDateValue(name, resolver);
        }
        if ("String".equals(type)) {
            return new JsStringValue(name, resolver);
        }
        if ("Boolean".equals(type)) {
            return new JsBooleanValue(name, resolver);
        }
        if ("ID".equals(type)) {
            return new JsIriValue(name, resolver);
        }
        return new JsValue(name, resolver);
    }
}

