/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script;

import com.ontotext.models.Selection;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.mutation.data.generation.DataGenerationContext;
import com.ontotext.models.mutation.data.generation.DataGenerator;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.script.ValueGenerator;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionsDataGenerator
implements DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final OperationResponse OK = new OperationResponse();
    private ValueGenerator valueGenerator;

    public OperationResponse visit(Query query, DataGenerationContext context) {
        return OK;
    }

    public OperationResponse visit(Selection selection, DataGenerationContext context) {
        return OK;
    }

    public OperationResponse visit(CreateMutation mutation, DataGenerationContext context) {
        return this.visitInternal((Mutation)mutation, context);
    }

    public OperationResponse visit(UpdateMutation mutation, DataGenerationContext context) {
        return this.visitInternal((Mutation)mutation, context);
    }

    public OperationResponse visit(DeleteMutation deleteMutation, DataGenerationContext context) {
        return OK;
    }

    public OperationResponse visit(Subscription subscription, DataGenerationContext context) {
        return OK;
    }

    private OperationResponse visitInternal(Mutation mutation, DataGenerationContext context) {
        if (!context.getOptions().isEnabled(this.getClass())) {
            return OK;
        }
        OperationResponse response = new OperationResponse();
        Map<String, Change> referenceMapping = ExpressionsDataGenerator.collectReferenceIds(mutation, response);
        if (!response.isValid()) {
            return response;
        }
        try {
            this.getValueGenerator().generateValues(mutation);
        }
        catch (Exception pe) {
            LOGGER.warn("Data generation failed!", (Throwable)pe);
            OperationResponse error = new OperationResponse();
            error.addError(pe.getMessage());
            return error;
        }
        this.updateReferences(mutation, referenceMapping, context);
        return OK;
    }

    private ValueGenerator getValueGenerator() {
        if (this.valueGenerator == null) {
            this.valueGenerator = new ValueGenerator();
        }
        return this.valueGenerator;
    }

    private static Map<String, Change> collectReferenceIds(Mutation mutation, OperationResponse response) {
        LinkedHashMap<String, Change> referenceMapping = new LinkedHashMap<String, Change>();
        BinaryOperator<Change> merger = ExpressionsDataGenerator.validatingMerger(response);
        for (Change change : mutation.getChanges()) {
            if (!ReferenceId.isReferenceId((String)change.getId()) || ReferenceId.isTemporaryId((String)change.getId())) continue;
            referenceMapping.merge(change.getId(), change, merger);
        }
        return referenceMapping;
    }

    private static BinaryOperator<Change> validatingMerger(OperationResponse response) {
        return (oldChange, newChange) -> {
            response.addErrorMessage("duplicate.reference.id", new Object[]{oldChange.getId()});
            return null;
        };
    }

    private void updateReferences(Mutation mutation, Map<String, Change> referenceMapping, DataGenerationContext context) {
        Map data = context.getData();
        Object resolver = data.computeIfAbsent("referenceResolver", k -> new LinkedHashMap());
        assert (resolver instanceof Map) : "Reference resolver should be a map but is: " + String.valueOf(resolver);
        Map referenceResolver = (Map)resolver;
        if (referenceMapping.isEmpty() && referenceResolver.isEmpty()) {
            return;
        }
        referenceMapping.forEach((referenceId, change) -> referenceResolver.put(referenceId, change.getId()));
        for (Change change2 : mutation.getChanges()) {
            change2.transformChanges(this.updateReferences(referenceResolver));
        }
    }

    private UnaryOperator<PropertyChange> updateReferences(Map<String, String> referenceResolver) {
        return change -> {
            if (ExpressionsDataGenerator.matches(referenceResolver, change.getRawValue()) || ExpressionsDataGenerator.matches(referenceResolver, change.getRawPatch())) {
                Object newValue = ExpressionsDataGenerator.convertValue(referenceResolver, change.getRawValue());
                Object newPatch = ExpressionsDataGenerator.convertValue(referenceResolver, change.getRawPatch());
                return change.copyChange(newValue, newPatch, null);
            }
            return change;
        };
    }

    private static boolean matches(Map<String, String> referenceResolver, Object value) {
        if (value instanceof String) {
            return referenceResolver.containsKey(value.toString());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().filter(String.class::isInstance).map(String::valueOf).anyMatch(referenceResolver::containsKey);
        }
        return false;
    }

    private static Object convertValue(Map<String, String> referenceResolver, Object value) {
        if (value instanceof String) {
            return referenceResolver.getOrDefault(value.toString(), value.toString());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(val -> referenceResolver.getOrDefault(val.toString(), val.toString())).collect(Collectors.toList());
        }
        return value;
    }
}

