/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class MappingOntologyUtils {
    public static ImmutableSet<OWLDeclarationAxiom> extractAndInsertDeclarationAxioms(OWLOntology ontology, ImmutableList<? extends SQLPPTriplesMap> tripleMaps, TypeFactory typeFactory, boolean bootstrappedMapping) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        ImmutableSet declarationAxioms = (ImmutableSet)tripleMaps.stream().flatMap(ax -> ax.getTargetAtoms().stream()).map(ta -> MappingOntologyUtils.extractEntity(ta, dataFactory, typeFactory, bootstrappedMapping)).map(arg_0 -> ((OWLDataFactory)dataFactory).getOWLDeclarationAxiom(arg_0)).collect(ImmutableCollectors.toSet());
        manager.addAxioms(ontology, (Collection)declarationAxioms);
        return declarationAxioms;
    }

    private static OWLEntity extractEntity(TargetAtom targetAtom, OWLDataFactory dataFactory, TypeFactory typeFactory, boolean bootstrappedMapping) {
        ImmutableList terms = targetAtom.getSubstitutedTerms();
        RDFAtomPredicate predicate = (RDFAtomPredicate)targetAtom.getProjectionAtom().getPredicate();
        Optional classIRI = predicate.getClassIRI(terms);
        Optional propertyIRI = predicate.getPropertyIRI(terms);
        if (classIRI.isPresent()) {
            return dataFactory.getOWLClass(org.semanticweb.owlapi.model.IRI.create((String)((IRI)classIRI.get()).getIRIString()));
        }
        if (!propertyIRI.isPresent()) {
            throw new MinorOntopInternalBugException("No IRI could be extracted from " + targetAtom);
        }
        org.semanticweb.owlapi.model.IRI iri = org.semanticweb.owlapi.model.IRI.create((String)((IRI)propertyIRI.get()).getIRIString());
        ImmutableTerm objectTerm = predicate.getObject(terms);
        if (objectTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm objectFunctionalTerm = (ImmutableFunctionalTerm)objectTerm;
            TermType termType = objectFunctionalTerm.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t.isA((TermType)typeFactory.getAbstractRDFTermType())).orElseThrow(() -> new MinorOntopInternalBugException("Could not infer the RDF type of " + objectFunctionalTerm));
            return termType.isA((TermType)typeFactory.getAbstractRDFSLiteral()) ? dataFactory.getOWLDataProperty(iri) : dataFactory.getOWLObjectProperty(iri);
        }
        if (bootstrappedMapping) {
            throw new MinorOntopInternalBugException("A functional term was expected for the object: " + objectTerm);
        }
        return dataFactory.getOWLDataProperty(iri);
    }
}

