/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.ontotext.forest.graphexplore.model.config.VisualGraphConfig;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.springframework.context.ApplicationEvent;

public class VisualGraphConfigEvent
extends ApplicationEvent {
    private final VisualGraphConfig graphConfig;
    private final String id;
    private final boolean delete;

    public VisualGraphConfigEvent(@Nullable VisualGraphConfig graphConfig, @Nullable String id, boolean delete) {
        super((Object)delete);
        this.graphConfig = graphConfig;
        this.id = id;
        this.delete = delete;
    }

    public VisualGraphConfig getGraphConfig() {
        return this.graphConfig;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public String getId() {
        return this.id;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] asBytes() {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream outputStream = new ObjectOutputStream(bytes);){
                outputStream.writeObject((Object)this);
                outputStream.flush();
                byArray = bytes.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

