/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.graphexplore.model.SavedGraph;
import com.ontotext.forest.graphexplore.service.SavedGraphsEvent;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.raft.GraphDBReplicationCluster;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SavedGraphService
implements ApplicationEventPublisherAware {
    private static final String PERSISTENCE_PROPERTY = "graphs";
    @Autowired
    private UsersConfig usersConfig;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private SemanticDataManagement dataManagement;
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public SavedGraph getSavedGraph(String id) {
        SavedGraph savedGraph = this.getGraphs().get(id);
        if (savedGraph == null) {
            this.notExists(id);
        }
        if (!this.getLoggedInUser().equals(savedGraph.getOwner())) {
            savedGraph.setOwner("");
        }
        if (StringUtils.isEmpty((Object)savedGraph.getConfig())) {
            savedGraph.setConfig("default");
        }
        return savedGraph;
    }

    public SavedGraph getSavedGraphByName(String name) {
        SavedGraph savedGraph;
        String user = this.getLoggedInUser();
        if (this.securityConfig.isUsernameFreeAccess(user)) {
            if (this.isDisabledFreeAccess()) {
                return null;
            }
            savedGraph = this.getGraphs().values().stream().filter(v -> v.isShared() && name.equals(v.getName())).findFirst().orElse(null);
        } else {
            savedGraph = this.getGraphs().values().stream().filter(v -> (user.equals(v.getOwner()) || v.isShared()) && name.equals(v.getName())).findFirst().orElse(null);
        }
        if (savedGraph != null && StringUtils.isEmpty((Object)savedGraph.getConfig())) {
            savedGraph.setConfig("default");
        }
        return savedGraph;
    }

    public List<SavedGraph> getSavedGraphs() {
        List<SavedGraph> graphs;
        String user = this.getLoggedInUser();
        if (this.securityConfig.isUsernameFreeAccess(user)) {
            if (this.isDisabledFreeAccess()) {
                return Collections.emptyList();
            }
            graphs = this.getGraphs().values().stream().filter(SavedGraph::isShared).sorted().collect(Collectors.toList());
        } else {
            graphs = this.getGraphs().values().stream().filter(v -> user.equals(v.getOwner()) || v.isShared()).sorted().collect(Collectors.toList());
        }
        for (SavedGraph savedGraph : graphs) {
            if (!StringUtils.isEmpty((Object)savedGraph.getConfig())) continue;
            savedGraph.setConfig("default");
        }
        return graphs;
    }

    public SavedGraph createSavedGraph(SavedGraph graph) {
        this.validateLeadership();
        graph.setId(this.newId());
        graph.setOwner(this.getLoggedInUser());
        if ("default".equals(graph.getConfig())) {
            graph.setConfig(null);
        }
        Map<String, SavedGraph> graphs = this.getGraphs();
        graphs.put(graph.getId(), graph);
        this.saveGraphs(graphs);
        return graph;
    }

    public void deleteSavedGraph(String id) {
        this.validateLeadership();
        Map<String, SavedGraph> graphs = this.getGraphs();
        SavedGraph savedGraph = graphs.get(id);
        if (savedGraph == null) {
            this.notExists(id);
        }
        if (!this.getLoggedInUser().equals(savedGraph.getOwner())) {
            throw new IllegalArgumentException("Unauthorized to delete this saved graph");
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SavedGraphsEvent(graphs));
        this.usersConfig.deleteMapEntry(PERSISTENCE_PROPERTY, SavedGraph.class, id);
    }

    private void notExists(String id) {
        throw new IllegalArgumentException("Saved graph '" + id + "' doesn't exist!");
    }

    public void editSavedGraph(SavedGraph newGraph) {
        this.validateLeadership();
        Map<String, SavedGraph> graphs = this.getGraphs();
        SavedGraph existingGraph = graphs.get(newGraph.getId());
        if (existingGraph == null) {
            this.notExists(newGraph.getId());
        }
        if (!this.getLoggedInUser().equals(existingGraph.getOwner())) {
            throw new IllegalArgumentException("Cannot update saved graph: " + newGraph.getName());
        }
        String newData = newGraph.getData();
        if (newData != null) {
            existingGraph.setData(newData);
        }
        if ("default".equals(existingGraph.getConfig())) {
            existingGraph.setConfig(null);
        }
        existingGraph.setName(newGraph.getName());
        existingGraph.setConfig(newGraph.getConfig());
        existingGraph.setShared(newGraph.isShared());
        graphs.put(existingGraph.getId(), existingGraph);
        this.saveGraphs(graphs);
    }

    private Map<String, SavedGraph> getGraphs() {
        return this.usersConfig.getMap(PERSISTENCE_PROPERTY, SavedGraph.class);
    }

    public void saveGraphsNoEvent(Map<String, SavedGraph> graphs) {
        this.usersConfig.updateMapEntries(PERSISTENCE_PROPERTY, SavedGraph.class, graphs);
    }

    private void saveGraphs(Map<String, SavedGraph> graphs) {
        this.validateLeadership();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SavedGraphsEvent(graphs));
        this.saveGraphsNoEvent(graphs);
    }

    private String newId() {
        String newId;
        Set<String> existingIds = this.getGraphs().keySet();
        if (existingIds.contains(newId = UUID.randomUUID().toString().replaceAll("-", ""))) {
            return this.newId();
        }
        return newId;
    }

    private void validateLeadership() {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            try {
                replicationCluster.validateLeadership();
            }
            catch (UpdateExecutionException e) {
                throw new GraphDBWorkbenchException(e.getMessage());
            }
            if (!replicationCluster.isPrimaryCluster()) {
                throw new GraphDBWorkbenchException("Unable to execute operation as node is in secondary cluster mode.");
            }
        }
    }

    String getLoggedInUser() {
        return this.securityConfig.getAuthenticatedUsername();
    }

    boolean isDisabledFreeAccess() {
        return !this.securityConfig.isEnabledFreeAccess();
    }

    SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }
}

