/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.service.URIPrefixService;
import com.ontotext.forest.graphexplore.model.RdfClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClassHierarchyService {
    private static final Logger LOG = LoggerFactory.getLogger(ClassHierarchyService.class);
    private static final String TOP_LEVEL_PARENT_ROLE = "topLevelParent";
    private static final String PARENT_ROLE = "parent";
    private static final String CHILD_ROLE = "child";
    private static final String[] UNIMPORTANT_CLASSES = new String[]{"http://www.w3.org/2002/07/owl#", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "http://www.w3.org/2000/01/rdf-schema#", "http://www.w3.org/2001/XMLSchema#", "http://www.w3.org/2004/02/skos/core#"};
    @Autowired
    private URIPrefixService uriPrefixService;

    private void processClassesNew(RdfClass parentRdfClass, String topLevelParentUri, Map<String, List<String>> class2data, Map<String, Set<String>> parent2children, Set<String> seenClasses, Collection<Namespace> namespaces, int depth, AtomicInteger id) throws GraphDBWorkbenchException {
        seenClasses.add(parentRdfClass.getTmpName());
        Set<String> childClasses = parent2children.get(parentRdfClass.getTmpName());
        if (childClasses == null || childClasses.isEmpty()) {
            parentRdfClass.setRole(CHILD_ROLE);
            return;
        }
        for (String child : childClasses) {
            if (seenClasses.contains(child)) continue;
            String fixedChild = this.rawClass(child);
            String name = this.uriPrefixService.resolveNamespaces(namespaces, fixedChild);
            if (!class2data.containsKey(fixedChild)) {
                LOG.warn("Class Data not found for " + fixedChild + ". Class Hierarchy will be incomplete.");
                throw new GraphDBWorkbenchException("Class hierarchy data is incomplete. Check your query timeout limit.");
            }
            List<String> childData = class2data.get(fixedChild);
            topLevelParentUri = parentRdfClass.getRole().equals(TOP_LEVEL_PARENT_ROLE) ? parentRdfClass.getFullName() : topLevelParentUri;
            RdfClass rdfClass = new RdfClass(name, fixedChild, child, topLevelParentUri, Integer.parseInt(childData.get(1)), PARENT_ROLE, depth, id.incrementAndGet());
            this.processClassesNew(rdfClass, topLevelParentUri, class2data, parent2children, seenClasses, namespaces, depth + 1, id);
            parentRdfClass.addChild(rdfClass);
        }
    }

    public RdfClass.ClassHierarchy constructRdfClassHierarchy(Set<String> allClasses, Set<String> topLevelParentClassUris, Map<String, String> child2parent, List<List<String>> countRawResults, Collection<Namespace> namespaces) throws GraphDBWorkbenchException {
        Map<String, Set<String>> parent2children = this.mapParent2Children(allClasses, child2parent);
        Map<String, List<String>> class2data = this.mapClass2Data(countRawResults);
        LinkedHashMap topLevelClasses = Maps.newLinkedHashMap();
        HashSet<String> seenClasses = new HashSet<String>();
        int depth = 0;
        AtomicInteger id = new AtomicInteger(1);
        for (String topLevelParentUri : topLevelParentClassUris) {
            String rawUri = this.rawClass(topLevelParentUri);
            List<String> parentData = class2data.get(rawUri);
            if (parentData == null) continue;
            String topLevelParentResolvedName = this.uriPrefixService.resolveNamespaces(namespaces, rawUri);
            int instancesCount = Integer.parseInt(parentData.get(1));
            RdfClass topLevelParentRdfClass = new RdfClass(topLevelParentResolvedName, rawUri, topLevelParentUri, "RDF Class Hierarchy", instancesCount, TOP_LEVEL_PARENT_ROLE, depth, id.incrementAndGet());
            topLevelClasses.put(topLevelParentUri, topLevelParentRdfClass);
            this.processClassesNew(topLevelParentRdfClass, "RDF Class Hierarchy", class2data, parent2children, seenClasses, namespaces, depth + 1, id);
        }
        ArrayList<RdfClass> topLevelClassesList = new ArrayList<RdfClass>(topLevelClasses.values());
        RdfClass.ClassHierarchy classHierarchy = new RdfClass.ClassHierarchy(topLevelClassesList);
        TreeSet namespacesSet = Sets.newTreeSet((Comparator)new RdfClass.NamespacesComparator());
        namespacesSet.addAll(namespaces);
        classHierarchy.setNamespaces(namespacesSet);
        return classHierarchy;
    }

    public Map.Entry<Set<Namespace>, Boolean> getNamespacesDiff(SemanticRepository repo, Set<Namespace> currentRepoNamespaces) {
        TreeSet newestNamespaces = Sets.newTreeSet((Comparator)new RdfClass.NamespacesComparator());
        newestNamespaces.addAll(repo.getNamespaces());
        return this.uriPrefixService.findNamespacesDiff(currentRepoNamespaces, (Set)newestNamespaces);
    }

    private Map<String, List<String>> mapClass2Data(List<List<String>> countRawResults) {
        HashMap<String, List<String>> class2data = new HashMap<String, List<String>>();
        for (List<String> countRawResult : countRawResults) {
            String klass = countRawResult.get(0);
            class2data.put(klass, countRawResult);
        }
        return class2data;
    }

    private Map<String, Set<String>> mapParent2Children(Set<String> allClasses, Map<String, String> child2parent) {
        HashMap<String, Set<String>> parent2children = new HashMap<String, Set<String>>();
        for (String klass : allClasses) {
            String parent = child2parent.get(klass);
            if (parent == null) continue;
            HashSet<String> children = (HashSet<String>)parent2children.get(parent);
            if (children == null) {
                children = new HashSet<String>();
                parent2children.put(parent, children);
            }
            children.add(klass);
        }
        return parent2children;
    }

    private String rawClass(String classWithIndex) {
        int pos = classWithIndex.indexOf(0);
        if (pos > 0) {
            return classWithIndex.substring(0, pos);
        }
        return classWithIndex;
    }

    public Map<String, String> mapChild2Parent(List<List<String>> classesRawResults, Set<String> allClasses) {
        HashMap<String, String> class2parent = new HashMap<String, String>();
        for (List<String> classData : classesRawResults) {
            String parent = classData.get(0);
            String cla\u00df = classData.get(1);
            if (this.classIsUnimportant(cla\u00df)) continue;
            allClasses.add(cla\u00df);
            if (cla\u00df.equals(parent) || this.classIsUnimportant(parent)) continue;
            allClasses.add(parent);
            class2parent.put(cla\u00df, parent);
        }
        return class2parent;
    }

    public List<List<String>> handleMultipleParents(List<List<String>> classesRawResults) {
        int maxIndex = classesRawResults.size() - 1;
        block0: for (int i = 0; i < maxIndex; ++i) {
            int j = 0;
            while (i + j + 1 < maxIndex) {
                List<String> data0 = classesRawResults.get(i + j);
                List<String> data1 = classesRawResults.get(i + j + 1);
                if (!data0.get(2).equals(data1.get(2))) continue block0;
                data1.set(1, data1.get(2) + "\u0000" + j);
                ++j;
            }
        }
        return classesRawResults;
    }

    private boolean classIsUnimportant(String className) {
        return Strings.isNullOrEmpty((String)className) || StringUtils.startsWithAny((CharSequence)className, (CharSequence[])UNIMPORTANT_CLASSES);
    }

    public RdfClass modifyConstructedHierarchy(RdfClass node, Function<RdfClass, String> nodeProcessingFunc, BiConsumer<RdfClass, String> nodePostProcessingFunc) {
        if (node == null) {
            return null;
        }
        String processedResult = nodeProcessingFunc.apply(node);
        nodePostProcessingFunc.accept(node, processedResult);
        for (RdfClass child : node.getChildren()) {
            this.modifyConstructedHierarchy(child, nodeProcessingFunc, nodePostProcessingFunc);
        }
        return null;
    }
}

