/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SparqlService;
import com.ontotext.forest.core.semantic.repository.RepositorySysInfoOptions;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.service.URIPrefixService;
import com.ontotext.forest.graphexplore.model.RdfClass;
import com.ontotext.forest.graphexplore.service.ClassHierarchyService;
import com.ontotext.forest.graphexplore.service.EquivalentClassesService;
import com.ontotext.forest.repositories.RepositoryUtils;
import com.ontotext.graphdb.Config;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClassHierachyStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(ClassHierachyStorageService.class);
    private Map<String, RdfClass.ClassHierarchy> classHierarchyCache;
    private ObjectMapper objectMapper = new ObjectMapper();
    private Path storagePath;
    private String currentLocationId;
    private final SemanticDataManagement semanticDataManagement;
    private final SparqlService sparqlService;
    private final ClassHierarchyService classHierarchyService;
    private final EquivalentClassesService equivalentClassesService;
    private RdfClass.ClassHierarchy currentClassHierarchy;
    private String currentRepoFingerprint = "";
    private final URIPrefixService uriPrefixService;
    private Map<String, Map.Entry<Set<Namespace>, Boolean>> repoNamespacesDiffsCache = Maps.newHashMap();
    private static final int MAX_QUERY_EXECUTION_TIME = 1800;

    @Autowired
    public ClassHierachyStorageService(SemanticDataManagement semanticDataManagement, ClassHierarchyService classHierarchyService, URIPrefixService uriPrefixService, EquivalentClassesService equivalentClassesService, SparqlService sparqlService) {
        this.semanticDataManagement = semanticDataManagement;
        this.classHierarchyService = classHierarchyService;
        this.uriPrefixService = uriPrefixService;
        this.equivalentClassesService = equivalentClassesService;
        this.sparqlService = sparqlService;
    }

    private void initClassHierarchy() {
        String locationHash = this.semanticDataManagement.getUniqueLocationId();
        if (locationHash.equals(this.currentLocationId)) {
            return;
        }
        this.currentLocationId = locationHash;
        this.storagePath = Paths.get(Config.getWorkDirectory(), "class-hierarchy", locationHash + ".json.gz");
        this.load();
    }

    public void updateClassHierarchyCacheWhenRepoRenamed(String oldRepoId, String newRepoId) {
        this.initClassHierarchy();
        String uniqueRepoId = this.semanticDataManagement.getUniqueRepositoryId(oldRepoId);
        List<String> savedClassHierarchyIdsForRepo = this.getSavedClassHierarchyIdsForRepo(uniqueRepoId);
        String uniqueNewRepoId = this.semanticDataManagement.getUniqueRepositoryId(newRepoId);
        for (String currentClassHierarchyIdForRepo : savedClassHierarchyIdsForRepo) {
            this.currentClassHierarchy = this.classHierarchyCache.get(currentClassHierarchyIdForRepo);
            if (this.currentClassHierarchy == null) continue;
            String newClassHierarchyId = currentClassHierarchyIdForRepo.replace(uniqueRepoId, uniqueNewRepoId);
            this.classHierarchyCache.put(newClassHierarchyId, this.currentClassHierarchy);
            this.classHierarchyCache.remove(currentClassHierarchyIdForRepo);
        }
        if (!savedClassHierarchyIdsForRepo.isEmpty()) {
            this.save();
        }
    }

    public void removeRepoClassHierarchyFromCache(String repoId) {
        this.initClassHierarchy();
        List<String> savedClassHierarchyIdsForRepo = this.getSavedClassHierarchyIdsForRepo(this.semanticDataManagement.getUniqueRepositoryId(repoId));
        for (String currentClassHierarchyIdForRepo : savedClassHierarchyIdsForRepo) {
            this.currentClassHierarchy = this.classHierarchyCache.get(currentClassHierarchyIdForRepo);
            if (this.currentClassHierarchy == null) continue;
            this.classHierarchyCache.remove(currentClassHierarchyIdForRepo);
        }
        if (!savedClassHierarchyIdsForRepo.isEmpty()) {
            this.save();
        }
    }

    private synchronized void save() {
        try {
            Files.createDirectories(this.storagePath.getParent(), new FileAttribute[0]);
            try (GZIPOutputStream is = new GZIPOutputStream(new FileOutputStream(this.storagePath.toFile()));){
                this.objectMapper.writeValue((OutputStream)is, this.classHierarchyCache);
            }
        }
        catch (IOException e) {
            LOG.error("Error saving class hierarchy cache", (Throwable)e);
        }
    }

    private synchronized void load() {
        if (Files.exists(this.storagePath, new LinkOption[0])) {
            try (GZIPInputStream is = new GZIPInputStream(new FileInputStream(this.storagePath.toFile()));){
                this.classHierarchyCache = (Map)this.objectMapper.readValue((InputStream)is, (JavaType)this.objectMapper.getTypeFactory().constructMapType(ConcurrentSkipListMap.class, String.class, RdfClass.ClassHierarchy.class));
            }
            catch (IOException e) {
                LOG.error("Error loading class hierarchy cache", (Throwable)e);
                this.classHierarchyCache = new ConcurrentSkipListMap<String, RdfClass.ClassHierarchy>();
            }
        } else {
            this.classHierarchyCache = new ConcurrentSkipListMap<String, RdfClass.ClassHierarchy>();
        }
    }

    private boolean isValidIRI(String uri) {
        return uri != null && !uri.contains("\u0000") && !CharMatcher.anyOf((CharSequence)"<>\\{}|^` \"").matchesAnyOf((CharSequence)uri);
    }

    public synchronized RdfClass.ClassHierarchy getClassHierarchy(final boolean doReload, final String graphURI) throws GraphDBWorkbenchException {
        this.initClassHierarchy();
        final SemanticRepository repo = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        final boolean isOntopRepo = RepositoryUtils.isOntopRepository((SemanticRepository)repo, (SemanticLocation)semanticLocation);
        final boolean isFedXRepo = RepositoryUtils.isFedXRepository((SemanticRepository)repo, (SemanticLocation)semanticLocation);
        SemanticRepository semanticRepository = repo;
        Objects.requireNonNull(semanticRepository);
        return (RdfClass.ClassHierarchy)new SemanticRepository.WithConnection<RdfClass.ClassHierarchy>(semanticRepository){

            protected RdfClass.ClassHierarchy doInConnection() throws RepositoryException {
                try {
                    String fingerprint = "";
                    if (!isOntopRepo && !isFedXRepo) {
                        fingerprint = ((Literal)repo.getSysInfoMap().get(RepositorySysInfoOptions.FINGERPRINT)).stringValue();
                    }
                    try {
                        ClassHierachyStorageService.this.currentClassHierarchy = ClassHierachyStorageService.this.classHierarchyCache.get(this.getClassHierarchyKey(graphURI));
                        if (ClassHierachyStorageService.this.currentClassHierarchy != null) {
                            Map.Entry<Set<Namespace>, Boolean> currentNamespacesDiff;
                            Set<Namespace> namespaces = this.asNamespacesSet();
                            ClassHierachyStorageService.this.currentClassHierarchy.setNamespaces(namespaces);
                            this.markClassHierarchyAsToBeUpdatedIfNeeded(fingerprint);
                            Map.Entry<Set<Namespace>, Boolean> namespacesDiff = ClassHierachyStorageService.this.classHierarchyService.getNamespacesDiff(repo, ClassHierachyStorageService.this.currentClassHierarchy.getNamespaces());
                            if (!namespacesDiff.getKey().isEmpty()) {
                                ClassHierachyStorageService.this.repoNamespacesDiffsCache.put(ClassHierachyStorageService.this.semanticDataManagement.getUniqueRepositoryId(repo), namespacesDiff);
                            }
                            if ((currentNamespacesDiff = ClassHierachyStorageService.this.repoNamespacesDiffsCache.get(ClassHierachyStorageService.this.semanticDataManagement.getUniqueRepositoryId(repo))) != null) {
                                this.updateClassLabelsIfNeeded(currentNamespacesDiff, graphURI);
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof VirtualMachineError) {
                            throw e;
                        }
                        ClassHierachyStorageService.this.currentClassHierarchy = null;
                        LOG.warn("Couldn't load cached class hierarchy ({}), will regenerate it instead.", e.getClass());
                    }
                    if (doReload || ClassHierachyStorageService.this.currentClassHierarchy == null) {
                        if (!isOntopRepo && !isFedXRepo) {
                            ClassHierachyStorageService.this.currentRepoFingerprint = ((Literal)repo.getSysInfoMap().get(RepositorySysInfoOptions.FINGERPRINT)).stringValue();
                        }
                        List<List<String>> classesRawResults = ClassHierachyStorageService.this.sparqlService.getFlattenedResultsForAllQueryBindings(this.prepareAndEvaluate(StringUtils.isEmpty((CharSequence)graphURI) ? ClassHierachyStorageService.this.sparqlService.readQueryString("dataviz-queries/getDirectSubclasses") : ClassHierachyStorageService.this.sparqlService.readQueryString("dataviz-queries/getDirectSubclassesFromNamedGraph").replace("{{graphURI}}", graphURI), 1800));
                        classesRawResults = this.handleEquivalentClasses(classesRawResults);
                        Collections.sort(classesRawResults, (o1, o2) -> ((String)o1.get(1)).compareTo((String)o2.get(2)));
                        classesRawResults = ClassHierachyStorageService.this.classHierarchyService.handleMultipleParents(classesRawResults);
                        HashSet<String> allClasses = new HashSet<String>();
                        List classesNoParent = ClassHierachyStorageService.this.sparqlService.getFlattenedResultsForAllQueryBindings(this.prepareAndEvaluate(ClassHierachyStorageService.this.sparqlService.readQueryString("dataviz-queries/getClassesNoParent").replace("{{graphURI}}", (CharSequence)(StringUtils.isEmpty((CharSequence)graphURI) ? "" : "FROM <" + graphURI + ">")), 1800));
                        List<List<String>> allNodes = Stream.concat(classesRawResults.stream(), classesNoParent.stream()).collect(Collectors.toList());
                        Map<String, String> child2parent = ClassHierachyStorageService.this.classHierarchyService.mapChild2Parent(allNodes, allClasses);
                        Sets.SetView topLevelParentClasses = Sets.difference(allClasses, child2parent.keySet());
                        Set filteredClasses = Sets.filter(allClasses, s -> ClassHierachyStorageService.this.isValidIRI((String)s));
                        String queryString = ClassHierachyStorageService.this.sparqlService.readQueryString("dataviz-queries/getClassInstanceCount").replace("{{classes}}", "<" + StringUtils.join((Iterable)filteredClasses, (String)"> <") + ">");
                        String currentRepositoryId = ClassHierachyStorageService.this.semanticDataManagement.getUniqueRepositoryId(repo);
                        if (!allClasses.isEmpty()) {
                            List countRawResults = ClassHierachyStorageService.this.sparqlService.getFlattenedResultsForAllQueryBindings(this.prepareAndEvaluate(queryString, 1800));
                            List namespaces = repo.getNamespaces();
                            Map<String, String> namespacesMap = namespaces.stream().collect(Collectors.toMap(Namespace::getPrefix, Namespace::getName));
                            ClassHierachyStorageService.this.currentClassHierarchy = ClassHierachyStorageService.this.classHierarchyService.constructRdfClassHierarchy(allClasses, (Set<String>)topLevelParentClasses, child2parent, countRawResults, namespaces);
                            ClassHierachyStorageService.this.currentClassHierarchy.setNamespacesMap(namespacesMap);
                            ClassHierachyStorageService.this.currentClassHierarchy.setRepoFingerprint(ClassHierachyStorageService.this.currentRepoFingerprint);
                            ClassHierachyStorageService.this.classHierarchyCache.put(this.getClassHierarchyKey(graphURI), ClassHierachyStorageService.this.currentClassHierarchy);
                            ClassHierachyStorageService.this.save();
                        } else {
                            ClassHierachyStorageService.this.classHierarchyCache.remove(currentRepositoryId);
                            ClassHierachyStorageService.this.save();
                            return new RdfClass.ClassHierarchy(Collections.emptyList());
                        }
                    }
                    return ClassHierachyStorageService.this.currentClassHierarchy;
                }
                catch (Exception e) {
                    LOG.error("Cannot get class hierarchy", (Throwable)e);
                    return null;
                }
            }

            private Set<Namespace> asNamespacesSet() {
                HashSet namespaces = Sets.newHashSet();
                ClassHierachyStorageService.this.currentClassHierarchy.getNamespacesMap().forEach((k, v) -> namespaces.add(new SimpleNamespace(k, v)));
                return namespaces;
            }

            private void markClassHierarchyAsToBeUpdatedIfNeeded(String newestFingerprint) {
                if (!ClassHierachyStorageService.this.currentClassHierarchy.getRepoFingerprint().equals(newestFingerprint)) {
                    ClassHierachyStorageService.this.currentClassHierarchy.setUpdated(true);
                }
            }

            private void updateClassLabelsIfNeeded(Map.Entry<Set<Namespace>, Boolean> namespacesDiff, String graphURI2) {
                Set<Namespace> namespaces = namespacesDiff.getKey();
                if (!namespaces.isEmpty()) {
                    for (RdfClass node : ClassHierachyStorageService.this.currentClassHierarchy.getChildren()) {
                        ClassHierachyStorageService.this.classHierarchyService.modifyConstructedHierarchy(node, n -> ClassHierachyStorageService.this.uriPrefixService.resolveChangedOrDeletedNamespaces((Collection)namespaces, n.getName(), n.getFullName(), ((Boolean)namespacesDiff.getValue()).booleanValue()), RdfClass::setName);
                    }
                    ClassHierachyStorageService.this.classHierarchyCache.put(this.getClassHierarchyKey(graphURI2), ClassHierachyStorageService.this.currentClassHierarchy);
                    ClassHierachyStorageService.this.save();
                }
            }

            private List<List<String>> handleEquivalentClasses(List<List<String>> classesRawResults) throws RDF4JException, IOException {
                if (!classesRawResults.isEmpty()) {
                    List equivalentResults = ClassHierachyStorageService.this.sparqlService.getFlattenedResultsForAllQueryBindings(this.prepareAndEvaluate(ClassHierachyStorageService.this.sparqlService.readQueryString("dataviz-queries/getEquivalentClasses"), 1800));
                    for (List classData : equivalentResults) {
                        String classA = (String)classData.get(0);
                        String classB = (String)classData.get(1);
                        ClassHierachyStorageService.this.equivalentClassesService.addEquivalentClasses(classA, classB);
                    }
                }
                ArrayList<List<String>> classesRawResultsNew = new ArrayList<List<String>>(classesRawResults.size());
                HashSet<CallSite> seenPairs = new HashSet<CallSite>();
                for (List<String> classData : classesRawResults) {
                    String cla\u00df;
                    String parent = ClassHierachyStorageService.this.equivalentClassesService.getNormalisedClass(classData.get(0));
                    String pcKey = parent + " " + (cla\u00df = ClassHierachyStorageService.this.equivalentClassesService.getNormalisedClass(classData.get(1)));
                    if (seenPairs.contains(pcKey) || parent.equals(cla\u00df)) continue;
                    seenPairs.add((CallSite)((Object)pcKey));
                    classesRawResultsNew.add(Arrays.asList(parent, cla\u00df, cla\u00df));
                }
                return classesRawResultsNew;
            }

            private String getClassHierarchyKey(String graphURI2) {
                return StringUtils.isEmpty((CharSequence)graphURI2) ? ClassHierachyStorageService.this.semanticDataManagement.getUniqueRepositoryId(repo) : ClassHierachyStorageService.this.semanticDataManagement.getUniqueRepositoryId(repo) + "-" + graphURI2;
            }
        }.run();
    }

    private List<String> getSavedClassHierarchyIdsForRepo(String repoId) {
        ArrayList<String> savedClassHierarchies = new ArrayList<String>();
        for (String savedClassHierarchiesReposId : this.classHierarchyCache.keySet()) {
            if (!savedClassHierarchiesReposId.startsWith(repoId)) continue;
            savedClassHierarchies.add(savedClassHierarchiesReposId);
        }
        return savedClassHierarchies;
    }
}

